/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.metadata.exif;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import org.jphototagger.domain.metadata.exif.Exif;
import org.jphototagger.domain.metadata.exif.ExifInfo;
import org.jphototagger.domain.metadata.exif.ExifReader;
import org.jphototagger.domain.metadata.exif.ExifTag;
import org.openide.util.Lookup;

public final class ExifUtil {
    public static Exif readExif(File file) {
        Collection exifReaders = Lookup.getDefault().lookupAll(ExifReader.class);
        for (ExifReader exifReader : exifReaders) {
            Exif readExif = null;
            if (exifReader.canReadExif(file)) {
                readExif = exifReader.readExif(file);
            }
            if (readExif == null) continue;
            return readExif;
        }
        return null;
    }

    public static Exif readExifPreferCached(File file) {
        Collection exifReaders = Lookup.getDefault().lookupAll(ExifReader.class);
        for (ExifReader exifReader : exifReaders) {
            Exif readExif = null;
            if (exifReader.canReadExif(file)) {
                readExif = exifReader.readExifPreferCached(file);
            }
            if (readExif == null) continue;
            return readExif;
        }
        return null;
    }

    public static Collection<ExifTag> getExifTags(File file) {
        Collection exifInfos = Lookup.getDefault().lookupAll(ExifInfo.class);
        LinkedList<ExifTag> exifTags = new LinkedList<ExifTag>();
        for (ExifInfo exifInfo : exifInfos) {
            exifTags.addAll(exifInfo.getExifTags(file));
        }
        return exifTags;
    }

    public static Collection<ExifTag> getExifTagsPreferCached(File file) {
        Collection exifInfos = Lookup.getDefault().lookupAll(ExifInfo.class);
        LinkedList<ExifTag> exifTags = new LinkedList<ExifTag>();
        for (ExifInfo exifInfo : exifInfos) {
            exifTags.addAll(exifInfo.getExifTagsPreferCached(file));
        }
        return exifTags;
    }

    private ExifUtil() {
    }
}

