/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.metadata.exif;

import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlTransient;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.exif.ExifDateTimeOriginalMetaDataValue;
import org.jphototagger.domain.metadata.exif.ExifFocalLengthMetaDataValue;
import org.jphototagger.domain.metadata.exif.ExifIsoSpeedRatingsMetaDataValue;
import org.jphototagger.domain.metadata.exif.ExifLensMetaDataValue;
import org.jphototagger.domain.metadata.exif.ExifRecordingEquipmentMetaDataValue;
import org.jphototagger.lib.util.StringUtil;

public final class Exif {
    private Date dateTimeOriginal;
    private double focalLength = -1.0;
    private double gpsLatitude = -2.147483648E9;
    private double gpsLongitude = -2.147483648E9;
    private short isoSpeedRatings = (short)-1;
    private String recordingEquipment;
    private String lens;
    private long dateTimeOriginalTimestamp = -1L;
    @XmlTransient
    private final Map<MetaDataValue, Object> metadataValues = new HashMap<MetaDataValue, Object>();
    @XmlTransient
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public Date getDateTimeOriginal() {
        return this.dateTimeOriginal == null ? null : new Date(this.dateTimeOriginal.getTime());
    }

    public void setDateTimeOriginal(Date dateTimeOriginal) {
        this.dateTimeOriginal = dateTimeOriginal == null ? null : new Date(dateTimeOriginal.getTime());
        this.metadataValues.put(ExifDateTimeOriginalMetaDataValue.INSTANCE, this.dateTimeOriginal);
    }

    public void setDateTimeOriginalTimestamp(long timestamp) {
        this.dateTimeOriginalTimestamp = timestamp;
    }

    public long getDateTimeOriginalTimestamp() {
        return this.dateTimeOriginalTimestamp;
    }

    public Long getDateTimeOriginalTimestampGreaterZeroOrNull() {
        return this.dateTimeOriginalTimestamp > 0L ? Long.valueOf(this.dateTimeOriginalTimestamp) : null;
    }

    public double getFocalLength() {
        return this.focalLength;
    }

    public Double getFocalLengthGreaterZeroOrNull() {
        return this.focalLength > 0.0 ? Double.valueOf(this.focalLength) : null;
    }

    public void setFocalLength(double focalLength) {
        this.focalLength = focalLength;
        this.metadataValues.put(ExifFocalLengthMetaDataValue.INSTANCE, this.focalLength);
    }

    public short getIsoSpeedRatings() {
        return this.isoSpeedRatings;
    }

    public Short getIsoSpeedRatingsGreaterZeroOrNull() {
        return this.isoSpeedRatings > 0 ? Short.valueOf(this.isoSpeedRatings) : null;
    }

    public void setIsoSpeedRatings(short isoSpeedRatings) {
        this.isoSpeedRatings = isoSpeedRatings;
        this.metadataValues.put(ExifIsoSpeedRatingsMetaDataValue.INSTANCE, this.isoSpeedRatings);
    }

    public String getRecordingEquipment() {
        return this.recordingEquipment;
    }

    public void setRecordingEquipment(String recordingEquipment) {
        this.recordingEquipment = recordingEquipment == null || recordingEquipment.equals("0") ? null : recordingEquipment;
        this.metadataValues.put(ExifRecordingEquipmentMetaDataValue.INSTANCE, this.recordingEquipment);
    }

    public String getLens() {
        return this.lens;
    }

    public void setLens(String lens) {
        this.lens = lens;
        this.metadataValues.put(ExifLensMetaDataValue.INSTANCE, this.lens);
    }

    public void resetGps() {
        this.gpsLatitude = -2.147483648E9;
        this.gpsLongitude = -2.147483648E9;
    }

    public double getGpsLatitude() {
        return this.gpsLatitude;
    }

    public void setGpsLatitude(double gpsLatitudeDegrees) {
        this.gpsLatitude = gpsLatitudeDegrees;
    }

    public double getGpsLongitude() {
        return this.gpsLongitude;
    }

    public void setGpsLongitude(double gpsLongitudeDegrees) {
        this.gpsLongitude = gpsLongitudeDegrees;
    }

    public boolean hasGpsCoordinates() {
        return this.gpsLatitude >= -180.0 && this.gpsLatitude <= 180.0 && this.gpsLongitude >= -180.0 && this.gpsLongitude <= 180.0;
    }

    public String getXmpDateCreated() {
        if (this.dateTimeOriginal == null) {
            return "";
        }
        return DATE_FORMAT.format(this.dateTimeOriginal);
    }

    public Object getValue(MetaDataValue mdv) {
        return this.metadataValues.get(mdv);
    }

    public boolean isEmpty() {
        return this.dateTimeOriginal == null && this.focalLength < 0.0 && this.isoSpeedRatings < 0 && this.dateTimeOriginalTimestamp < 0L && !StringUtil.hasContent((String)this.lens) && !StringUtil.hasContent((String)this.recordingEquipment);
    }
}

