/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.metadata;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.MetaDataValueData;
import org.jphototagger.domain.metadata.MetaDataValueProvider;
import org.openide.util.Lookup;

public final class MetaDataValueProviderSupport {
    private final Map<MetaDataValue, List<MetaDataValueProvider>> providersOfValue = new HashMap<MetaDataValue, List<MetaDataValueProvider>>();

    public MetaDataValueProviderSupport() {
        this.lookupProviders();
    }

    private void lookupProviders() {
        Collection providers = Lookup.getDefault().lookupAll(MetaDataValueProvider.class);
        for (MetaDataValueProvider provider : providers) {
            for (MetaDataValue value : provider.getProvidedValues()) {
                List<MetaDataValueProvider> valueProviders = this.providersOfValue.get(value);
                if (valueProviders == null) {
                    valueProviders = new ArrayList<MetaDataValueProvider>();
                    this.providersOfValue.put(value, valueProviders);
                }
                valueProviders.add(provider);
            }
        }
    }

    public Collection<MetaDataValueData> lookupMetaDataForFile(File file, MetaDataValue forValue) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (forValue == null) {
            throw new NullPointerException("forValue == null");
        }
        ArrayList<MetaDataValueData> metaData = new ArrayList<MetaDataValueData>();
        List<MetaDataValueProvider> valueProviders = this.providersOfValue.get(forValue);
        if (valueProviders != null) {
            for (MetaDataValueProvider provider : valueProviders) {
                for (MetaDataValueData valueData : provider.getMetaDataForImageFile(file)) {
                    if (!forValue.equals(valueData.getMetaDataValue())) continue;
                    metaData.add(valueData);
                }
            }
        }
        return metaData;
    }
}

