/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.metadata;

import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;
import javax.swing.text.NumberFormatter;
import org.jphototagger.domain.metadata.MetaDataValue;

final class MetaDataValueFormatterFactory {
    private static DefaultFormatterFactory integerFormatterFactory;
    private static DefaultFormatterFactory doubleFormatterFactory;
    private static DefaultFormatterFactory dateFormatterFactory;
    private static final DefaultFormatterFactory defaultFormatterFactory;

    public static DefaultFormatterFactory getFormatterFactory(MetaDataValue mdValue) {
        if (mdValue == null) {
            throw new NullPointerException("mdValue == null");
        }
        MetaDataValue.ValueType type = mdValue.getValueType();
        if (type.equals((Object)MetaDataValue.ValueType.DATE)) {
            return dateFormatterFactory;
        }
        if (type.equals((Object)MetaDataValue.ValueType.BIGINT) || type.equals((Object)MetaDataValue.ValueType.INTEGER) || type.equals((Object)MetaDataValue.ValueType.SMALLINT)) {
            return integerFormatterFactory;
        }
        if (type.equals((Object)MetaDataValue.ValueType.REAL)) {
            return doubleFormatterFactory;
        }
        return defaultFormatterFactory;
    }

    private MetaDataValueFormatterFactory() {
    }

    static {
        defaultFormatterFactory = new DefaultFormatterFactory(new DefaultFormatter());
        try {
            NumberFormat integerFormat = NumberFormat.getIntegerInstance();
            integerFormat.setGroupingUsed(false);
            NumberFormatter integerFormatter = new NumberFormatter(integerFormat);
            integerFormatter.setAllowsInvalid(false);
            MaskFormatter doubleFormatter = new MaskFormatter("####.##");
            doubleFormatter.setAllowsInvalid(false);
            integerFormatterFactory = new DefaultFormatterFactory(integerFormatter);
            doubleFormatterFactory = new DefaultFormatterFactory(doubleFormatter);
            dateFormatterFactory = new DefaultFormatterFactory(new MaskFormatter("####-##-##"));
        }
        catch (Throwable t) {
            Logger.getLogger(MetaDataValueFormatterFactory.class.getName()).log(Level.SEVERE, null, t);
        }
    }
}

