/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.metadata;

import java.sql.Date;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.InputVerifier;
import javax.swing.text.DefaultFormatterFactory;
import org.jphototagger.domain.metadata.MetaDataValueFormatterFactory;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.inputverifier.AlwaysTrueInputVerifier;
import org.jphototagger.lib.swing.inputverifier.DateInputVerifier;
import org.jphototagger.lib.swing.inputverifier.MaxLengthInputVerifier;
import org.jphototagger.lib.swing.inputverifier.NumberInputVerifier;
import org.jphototagger.lib.util.StringUtil;

public class MetaDataValue {
    private static final Icon CATEGORY_ICON_EXIF = IconUtil.getImageIcon(MetaDataValue.class, (String)"meata_data_value_category_exif.png");
    private static final Icon CATEGORY_ICON_FILE = IconUtil.getImageIcon(MetaDataValue.class, (String)"meata_data_value_category_file.png");
    private static final Icon CATEGORY_ICON_XMP = IconUtil.getImageIcon(MetaDataValue.class, (String)"meata_data_value_category_xmp.png");
    private static final Icon CATEGORY_ICON_UNDEFINED = IconUtil.getImageIcon(MetaDataValue.class, (String)"meata_data_value_category_undefined.png");
    private static final Map<String, Icon> ICON_OF_CATEGORY = new HashMap<String, Icon>();
    private final ValueType valueType;
    private String description;
    private int valueLength;
    private String longerDescription;
    private final String valueName;
    private final String category;

    protected MetaDataValue(String valueName, String category, ValueType valueType) {
        if (valueName == null) {
            throw new NullPointerException("valueName == null");
        }
        if (category == null) {
            throw new NullPointerException("category == null");
        }
        if (valueType == null) {
            throw new NullPointerException("valueType == null");
        }
        this.valueName = valueName;
        this.category = category;
        this.valueType = valueType;
    }

    public String getCategory() {
        return this.category;
    }

    public Icon getCategoryIcon() {
        if (!StringUtil.hasContent((String)this.category)) {
            return CATEGORY_ICON_UNDEFINED;
        }
        Icon icon = ICON_OF_CATEGORY.get(this.category);
        return icon == null ? CATEGORY_ICON_UNDEFINED : icon;
    }

    public String toString() {
        String desc = this.description == null ? "" : this.description.trim();
        return desc.isEmpty() ? this.valueName : desc;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MetaDataValue)) {
            return false;
        }
        MetaDataValue other = (MetaDataValue)object;
        return this.valueName.equals(other.valueName) && this.category.equals(other.category);
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (this.category != null ? this.category.hashCode() : 0);
        hash = 83 * hash + (this.valueName != null ? this.valueName.hashCode() : 0);
        return hash;
    }

    public int getValueLength() {
        return this.valueLength;
    }

    protected void setValueLength(int length) {
        this.valueLength = length;
    }

    public String getValueName() {
        return this.valueName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLongerDescription() {
        return this.longerDescription;
    }

    protected void setDescription(String description) {
        if (description == null) {
            throw new NullPointerException("description == null");
        }
        this.description = description;
    }

    protected void setLongerDescription(String description) {
        if (description == null) {
            throw new NullPointerException("description == null");
        }
        this.longerDescription = description;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public InputVerifier getInputVerifier() {
        return this.valueType.equals((Object)ValueType.STRING) ? new MaxLengthInputVerifier(this.valueLength) : this.valueType.defaultInputVerifier;
    }

    public DefaultFormatterFactory getFormatterFactory() {
        return MetaDataValueFormatterFactory.getFormatterFactory(this);
    }

    static {
        ICON_OF_CATEGORY.put("exif", CATEGORY_ICON_EXIF);
        ICON_OF_CATEGORY.put("exif_recording_equipment", CATEGORY_ICON_EXIF);
        ICON_OF_CATEGORY.put("exif_lenses", CATEGORY_ICON_EXIF);
        ICON_OF_CATEGORY.put("files", CATEGORY_ICON_FILE);
        ICON_OF_CATEGORY.put("xmp", CATEGORY_ICON_XMP);
        ICON_OF_CATEGORY.put("dc_creators", CATEGORY_ICON_XMP);
        ICON_OF_CATEGORY.put("dc_rights", CATEGORY_ICON_XMP);
        ICON_OF_CATEGORY.put("iptc4xmpcore_locations", CATEGORY_ICON_XMP);
        ICON_OF_CATEGORY.put("photoshop_authorspositions", CATEGORY_ICON_XMP);
        ICON_OF_CATEGORY.put("photoshop_captionwriters", CATEGORY_ICON_XMP);
        ICON_OF_CATEGORY.put("photoshop_cities", CATEGORY_ICON_XMP);
        ICON_OF_CATEGORY.put("photoshop_countries", CATEGORY_ICON_XMP);
        ICON_OF_CATEGORY.put("photoshop_credits", CATEGORY_ICON_XMP);
        ICON_OF_CATEGORY.put("photoshop_sources", CATEGORY_ICON_XMP);
        ICON_OF_CATEGORY.put("photoshop_states", CATEGORY_ICON_XMP);
        ICON_OF_CATEGORY.put("dc_subjects", CATEGORY_ICON_XMP);
    }

    public static enum ValueType {
        BINARY((InputVerifier)AlwaysTrueInputVerifier.INSTANCE),
        DATE((InputVerifier)new DateInputVerifier("yyyy-MM-dd")),
        INTEGER((InputVerifier)NumberInputVerifier.INSTANCE),
        BIGINT((InputVerifier)NumberInputVerifier.INSTANCE),
        REAL((InputVerifier)NumberInputVerifier.INSTANCE),
        SMALLINT((InputVerifier)NumberInputVerifier.INSTANCE),
        STRING((InputVerifier)AlwaysTrueInputVerifier.INSTANCE);

        private final InputVerifier defaultInputVerifier;

        private ValueType(InputVerifier inputVerifier) {
            this.defaultInputVerifier = inputVerifier;
        }

        public Object parseString(String string) {
            switch (this) {
                case BINARY: {
                    return string.getBytes();
                }
                case DATE: {
                    return this.string2date(string);
                }
                case INTEGER: {
                    return Integer.parseInt(string);
                }
                case BIGINT: {
                    return Long.parseLong(string);
                }
                case REAL: {
                    return Double.parseDouble(string);
                }
                case SMALLINT: {
                    return Short.parseShort(string);
                }
                case STRING: {
                    return string;
                }
            }
            throw new IllegalArgumentException("Not handled type: " + (Object)((Object)this));
        }

        private Object string2date(String s) {
            try {
                return new Date(DateFormat.getInstance().parse(s).getTime());
            }
            catch (Throwable t) {
                Logger.getLogger(MetaDataValue.class.getName()).log(Level.SEVERE, null, t);
                return s;
            }
        }
    }
}

