/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.imagecollections;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.jphototagger.lib.util.Bundle;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public final class ImageCollection {
    public static final transient String PREVIOUS_IMPORT_NAME = "SpecialCollectionName.PreviousImport";
    public static final transient String PICKED_NAME = "SpecialCollectionName.Picked";
    public static final transient String REJECTED_NAME = "SpecialCollectionName.Rejected";
    private static final transient Set<String> SPECIAL_COLLECTION_NAMES = new HashSet<String>(3);
    private static final transient Set<String> SPECIAL_COLLECTION_NAMES_LOWER_CASE = new HashSet<String>(3);
    private static final transient Set<String> LOCALIZED_SPECIAL_NAMES_LC = new HashSet<String>();
    private static final transient Map<String, String> LOCALIZED_NAME_OF_SPECIAL_NAME_LC = new HashMap<String, String>(3);
    @XmlElementWrapper(name="Filenames")
    @XmlElement(type=File.class)
    private List<File> imageFiles;
    private String name;

    public ImageCollection() {
    }

    public ImageCollection(String name, List<File> imageFiles) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (imageFiles == null) {
            throw new NullPointerException("imageFiles == null");
        }
        this.name = name;
        this.imageFiles = new ArrayList<File>(imageFiles);
    }

    public List<File> getFiles() {
        return this.imageFiles == null ? Collections.emptyList() : new ArrayList<File>(this.imageFiles);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name == null ? "" : this.name;
    }

    public static boolean isSpecialCollection(String collectionName) {
        if (collectionName == null) {
            throw new NullPointerException("collectionName == null");
        }
        String collectionNameLowerCase = collectionName.toLowerCase();
        return SPECIAL_COLLECTION_NAMES_LOWER_CASE.contains(collectionNameLowerCase) || LOCALIZED_SPECIAL_NAMES_LC.contains(collectionNameLowerCase);
    }

    public static Set<String> getSpecialCollectionNames() {
        return Collections.unmodifiableSet(SPECIAL_COLLECTION_NAMES);
    }

    public static String getLocalizedName(String name) {
        if (name == null) {
            return null;
        }
        String nameLowerCase = name.toLowerCase();
        if (LOCALIZED_NAME_OF_SPECIAL_NAME_LC.containsKey(nameLowerCase)) {
            return LOCALIZED_NAME_OF_SPECIAL_NAME_LC.get(nameLowerCase);
        }
        return name;
    }

    public static int getSpecialCollectionCount() {
        return SPECIAL_COLLECTION_NAMES.size();
    }

    static {
        SPECIAL_COLLECTION_NAMES.add(PICKED_NAME);
        SPECIAL_COLLECTION_NAMES.add(PREVIOUS_IMPORT_NAME);
        SPECIAL_COLLECTION_NAMES.add(REJECTED_NAME);
        for (String specialCollectionName : SPECIAL_COLLECTION_NAMES) {
            SPECIAL_COLLECTION_NAMES_LOWER_CASE.add(specialCollectionName.toLowerCase());
        }
        LOCALIZED_NAME_OF_SPECIAL_NAME_LC.put(PREVIOUS_IMPORT_NAME.toLowerCase(), Bundle.getString(ImageCollection.class, (String)"ImageCollection.Name.PrevImport", (Object[])new Object[0]));
        LOCALIZED_NAME_OF_SPECIAL_NAME_LC.put(PICKED_NAME.toLowerCase(), Bundle.getString(ImageCollection.class, (String)"ImageCollection.Name.Picked", (Object[])new Object[0]));
        LOCALIZED_NAME_OF_SPECIAL_NAME_LC.put(REJECTED_NAME.toLowerCase(), Bundle.getString(ImageCollection.class, (String)"ImageCollection.Name.Rejected", (Object[])new Object[0]));
        for (String name : LOCALIZED_NAME_OF_SPECIAL_NAME_LC.values()) {
            LOCALIZED_SPECIAL_NAMES_LC.add(name.toLowerCase());
        }
    }
}

