/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.image;

import java.awt.Image;
import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jphototagger.domain.metadata.exif.Exif;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.repository.SaveOrUpdate;

public final class ImageFile {
    private final Set<SaveOrUpdate> insertIntoDb = EnumSet.noneOf(SaveOrUpdate.class);
    private Exif exif;
    private File file;
    private long lastmodified = -1L;
    private long sizeInBytes;
    private Image thumbnail;
    private Xmp xmp;

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public Xmp getXmp() {
        return this.xmp;
    }

    public void setXmp(Xmp xmp) {
        this.xmp = xmp;
    }

    public long getLastmodified() {
        return this.lastmodified;
    }

    public void setLastmodified(long lastmodified) {
        this.lastmodified = lastmodified;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public void setSizeInBytes(long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    public Image getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(Image thumbnail) {
        this.thumbnail = thumbnail;
    }

    public Exif getExif() {
        return this.exif;
    }

    public void setExif(Exif exif) {
        this.exif = exif;
    }

    public boolean isSaveInRepository(SaveOrUpdate insert) {
        return this.insertIntoDb.contains((Object)insert);
    }

    public boolean isInsertXmpIntoDb() {
        return this.insertIntoDb.contains((Object)SaveOrUpdate.XMP);
    }

    public boolean isInsertExifIntoDb() {
        return this.insertIntoDb.contains((Object)SaveOrUpdate.EXIF);
    }

    public boolean isInsertThumbnailIntoDb() {
        return this.insertIntoDb.contains((Object)SaveOrUpdate.THUMBNAIL);
    }

    public Set<SaveOrUpdate> getInsertIntoDb() {
        return Collections.unmodifiableSet(this.insertIntoDb);
    }

    public void addToSaveIntoRepository(SaveOrUpdate insert) {
        if (insert == null) {
            throw new NullPointerException("insert == null");
        }
        this.insertIntoDb.add(insert);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageFile other = (ImageFile)obj;
        return this.file == other.file || this.file != null && this.file.equals(other.file);
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + (this.file != null ? this.file.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.file == null ? "" : this.file.toString();
    }
}

