/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.filefilter;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.jphototagger.lib.util.Bundle;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public final class UserDefinedFileFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private Boolean isNot = Boolean.FALSE;
    private Type type = Type.CONTAINS;
    private String name;
    private String expression;

    public UserDefinedFileFilter() {
    }

    public UserDefinedFileFilter(UserDefinedFileFilter other) {
        if (other == null) {
            throw new NullPointerException("other == null");
        }
        this.set(other);
    }

    public void set(UserDefinedFileFilter other) {
        if (other == null) {
            throw new NullPointerException("other == null");
        }
        if (other != this) {
            this.id = other.id;
            this.isNot = other.isNot;
            this.type = other.type;
            this.name = other.name;
            this.expression = other.expression;
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isValid() {
        return this.type != null && this.name != null && this.expression != null && !this.name.trim().isEmpty() && !this.expression.trim().isEmpty();
    }

    public RegexFileFilter getFileFilter() {
        return new RegexFileFilter(this.type.getRegex(this.expression), this.isNot, this.id);
    }

    public Boolean getIsNot() {
        return this.isNot;
    }

    public void setIsNot(Boolean isNot) {
        this.isNot = isNot;
    }

    public String toString() {
        return this.name == null ? "" : this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserDefinedFileFilter other = (UserDefinedFileFilter)obj;
        return this.id == other.id || this.id != null && this.id.equals(other.id);
    }

    public boolean filtersEquals(RegexFileFilter left, RegexFileFilter right) {
        if (left == null) {
            throw new NullPointerException("left == null");
        }
        if (right == null) {
            throw new NullPointerException("right == null");
        }
        return left.id == right.id;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.id != null ? this.id.hashCode() : 0);
        return hash;
    }

    public static class RegexFileFilter
    implements FileFilter,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String pattern;
        private final boolean isNot;
        private final long id;

        public RegexFileFilter(String pattern, boolean not, long id) {
            if (pattern == null) {
                throw new NullPointerException("pattern == null");
            }
            this.pattern = pattern;
            this.isNot = not;
            this.id = id;
        }

        @Override
        public boolean accept(File file) {
            String filename = file.getName();
            try {
                return this.isNot ? !filename.matches(this.pattern) : filename.matches(this.pattern);
            }
            catch (Throwable t) {
                Logger.getLogger(UserDefinedFileFilter.class.getName()).log(Level.SEVERE, null, t);
                return false;
            }
        }
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type STARTS_WITH = new Type(0, Bundle.getString(UserDefinedFileFilter.class, (String)"UserDefinedFileFilter.DisplayName.StartsWith", (Object[])new Object[0]));
        public static final /* enum */ Type CONTAINS = new Type(1, Bundle.getString(UserDefinedFileFilter.class, (String)"UserDefinedFileFilter.DisplayName.Contains", (Object[])new Object[0]));
        public static final /* enum */ Type ENDS_WITH = new Type(2, Bundle.getString(UserDefinedFileFilter.class, (String)"UserDefinedFileFilter.DisplayName.EndsWith", (Object[])new Object[0]));
        public static final /* enum */ Type REGEX = new Type(3, Bundle.getString(UserDefinedFileFilter.class, (String)"UserDefinedFileFilter.DisplayName.Regex", (Object[])new Object[0]));
        private final int value;
        private final String displayName;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(int value, String displayName) {
            this.value = value;
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int getValue() {
            return this.value;
        }

        public static Type parseValue(int value) {
            for (Type type : Type.values()) {
                if (type.value != value) continue;
                return type;
            }
            throw new IllegalArgumentException("Illegal value: " + value);
        }

        public String getRegex(String s) {
            switch (this) {
                case STARTS_WITH: {
                    return "^" + this.makeIgnoreCase(s) + ".*";
                }
                case ENDS_WITH: {
                    return ".*" + this.makeIgnoreCase(s) + "$";
                }
                case CONTAINS: {
                    return ".*" + this.makeIgnoreCase(s) + ".*";
                }
                case REGEX: {
                    return s;
                }
            }
            assert (false) : this;
            return "";
        }

        private String makeIgnoreCase(String s) {
            int length = s.length();
            StringBuilder sb = new StringBuilder(length * 4);
            String escaped = s.replace("\\", "\\\\").replace("*", "\\*").replace("[", "\\[").replace("]", "\\]");
            int escLength = escaped.length();
            for (int i = 0; i < escLength; ++i) {
                char c = escaped.charAt(i);
                if (Character.isLetter(c)) {
                    char lc = Character.toLowerCase(c);
                    char uc = Character.toUpperCase(c);
                    sb.append("[").append(uc).append(lc).append("]");
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }

        static {
            $VALUES = new Type[]{STARTS_WITH, CONTAINS, ENDS_WITH, REGEX};
        }
    }
}

