/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.filefilter;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.filefilter.AppFileFilterProvider;
import org.jphototagger.domain.repository.FileExcludePatternsRepository;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.io.filefilter.DirectoryFilter;
import org.jphototagger.lib.util.RegexUtil;
import org.openide.util.Lookup;

public final class FileFilterUtil {
    public static List<File> getImageFilesOfDirectory(File directory) {
        if (directory == null) {
            throw new NullPointerException("directory == null");
        }
        AppFileFilterProvider provider = (AppFileFilterProvider)Lookup.getDefault().lookup(AppFileFilterProvider.class);
        File[] filteredFiles = directory.listFiles(provider.getAcceptedImageFilesFileFilter());
        FileExcludePatternsRepository repo = (FileExcludePatternsRepository)Lookup.getDefault().lookup(FileExcludePatternsRepository.class);
        List<String> excludePatterns = repo.findAllFileExcludePatterns();
        ArrayList<File> files = new ArrayList<File>();
        if (filteredFiles != null) {
            for (File file : filteredFiles) {
                if (RegexUtil.containsMatch(excludePatterns, (String)file.getAbsolutePath())) continue;
                files.add(file);
            }
        }
        return files;
    }

    public static List<File> getImageFilesOfDirectories(List<File> directories) {
        if (directories == null) {
            throw new NullPointerException("directories == null");
        }
        ArrayList<File> files = new ArrayList<File>();
        for (File directory : directories) {
            files.addAll(FileFilterUtil.getImageFilesOfDirectory(directory));
        }
        return files;
    }

    public static List<File> getImageFilesOfDirAndSubDirs(File dir) {
        if (dir == null) {
            throw new NullPointerException("dir == null");
        }
        List dirAndSubdirs = FileUtil.getSubDirectoriesRecursive((File)dir, null, (DirectoryFilter.Option[])new DirectoryFilter.Option[]{FileFilterUtil.getDirFilterOptionShowHiddenFiles()});
        dirAndSubdirs.add(dir);
        return FileFilterUtil.getImageFilesOfDirectories(dirAndSubdirs);
    }

    private static DirectoryFilter.Option getDirFilterOptionShowHiddenFiles() {
        return FileFilterUtil.isAcceptHiddenDirectories() ? DirectoryFilter.Option.ACCEPT_HIDDEN_FILES : DirectoryFilter.Option.NO_OPTION;
    }

    private static boolean isAcceptHiddenDirectories() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.IsAcceptHiddenDirectories") ? prefs.getBoolean("UserSettings.IsAcceptHiddenDirectories") : false;
    }

    public static List<File> filterImageFiles(Collection<File> arbitraryFiles) {
        if (arbitraryFiles == null) {
            throw new NullPointerException("arbitraryFiles == null");
        }
        ArrayList<File> imageFiles = new ArrayList<File>();
        AppFileFilterProvider provider = (AppFileFilterProvider)Lookup.getDefault().lookup(AppFileFilterProvider.class);
        FileFilter filter = provider.getAcceptedImageFilesFileFilter();
        for (File file : arbitraryFiles) {
            if (!filter.accept(file)) continue;
            imageFiles.add(file);
        }
        return imageFiles;
    }

    public static boolean isImageFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        AppFileFilterProvider provider = (AppFileFilterProvider)Lookup.getDefault().lookup(AppFileFilterProvider.class);
        return provider.isAcceptedImageFile(file);
    }

    public static List<File> getImageFiles(Collection<? extends File> files) {
        if (files == null) {
            throw new NullPointerException("files == null");
        }
        ArrayList<File> imageFiles = new ArrayList<File>(files.size());
        for (File file : files) {
            if (!FileFilterUtil.isImageFile(file)) continue;
            imageFiles.add(file);
        }
        return imageFiles;
    }

    private FileFilterUtil() {
    }
}

