/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.iptc;

import com.imagero.reader.MetadataUtils;
import com.imagero.reader.iptc.IPTCEntry;
import com.imagero.reader.iptc.IPTCEntryCollection;
import com.imagero.reader.iptc.IPTCEntryMeta;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.domain.metadata.iptc.Iptc;
import org.jphototagger.iptc.IptcEntry;
import org.jphototagger.iptc.IptcSupport;

public final class IptcMetadata {
    private static final Logger LOGGER = Logger.getLogger(IptcMetadata.class.getName());

    public static List<IptcEntry> getIptcEntries(File imageFile) {
        ArrayList<IptcEntry> metadata = new ArrayList<IptcEntry>();
        if (imageFile != null && imageFile.exists() && IptcSupport.INSTANCE.canReadIptc(imageFile)) {
            try {
                LOGGER.log(Level.INFO, "Reading IPTC from image file ''{0}'', size {1} Bytes", new Object[]{imageFile, imageFile.length()});
                IPTCEntryCollection collection = MetadataUtils.getIPTC((File)imageFile);
                if (collection != null) {
                    IptcMetadata.addEntries(collection.getEntries(2), metadata);
                }
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, null, t);
            }
        }
        return metadata;
    }

    private static void addEntries(IPTCEntry[][] entries, List<IptcEntry> metadata) {
        if (entries != null) {
            for (IPTCEntry[] entrie : entries) {
                IptcMetadata.addEntries(entrie, metadata);
            }
        }
    }

    private static void addEntries(IPTCEntry[] entries, List<IptcEntry> metadata) {
        if (entries != null) {
            for (IPTCEntry currentEntry : entries) {
                IptcEntry newEntry;
                if (currentEntry == null || IptcMetadata.isVersionInfo(currentEntry) || !IptcMetadata.hasContent(newEntry = new IptcEntry(currentEntry)) || metadata.contains(newEntry)) continue;
                metadata.add(newEntry);
            }
        }
    }

    private static boolean hasContent(IptcEntry entry) {
        return entry.getData() != null && !entry.getData().trim().isEmpty();
    }

    private static boolean isVersionInfo(IPTCEntry entry) {
        return entry.getRecordNumber() == 2 && entry.getDataSetNumber() == 0;
    }

    public static List<IptcEntry> getFilteredEntries(List<IptcEntry> entries, IPTCEntryMeta filter) {
        if (entries == null) {
            throw new NullPointerException("entries == null");
        }
        if (filter == null) {
            throw new NullPointerException("filter == null");
        }
        ArrayList<IptcEntry> filteredEntries = new ArrayList<IptcEntry>();
        for (IptcEntry entry : entries) {
            if (!entry.getEntryMeta().equals(filter)) continue;
            filteredEntries.add(entry);
        }
        return filteredEntries;
    }

    public static Iptc getIptc(File imageFile) {
        Iptc iptc = null;
        List<IptcEntry> iptcEntries = IptcMetadata.getIptcEntries(imageFile);
        if (iptcEntries.size() > 0) {
            iptc = new Iptc();
            for (IptcEntry iptcEntry : iptcEntries) {
                IPTCEntryMeta iptcEntryMeta = iptcEntry.getEntryMeta();
                iptc.setValue(iptcEntryMeta, (Object)iptcEntry.getData());
            }
        }
        return iptc;
    }

    public static IPTCEntry findEntry(Collection<? extends IPTCEntry> entries, int recordNumber, int dataSetNumber) {
        if (entries == null) {
            throw new NullPointerException("entries == null");
        }
        for (IPTCEntry iPTCEntry : entries) {
            int recordNo = iPTCEntry.getRecordNumber();
            int dataSetNo = iPTCEntry.getDataSetNumber();
            if (recordNo != recordNumber || dataSetNo != dataSetNumber) continue;
            return iPTCEntry;
        }
        return null;
    }

    private IptcMetadata() {
    }
}

