/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.iptc;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.storage.CacheDirectoryProvider;
import org.jphototagger.domain.repository.event.imagefiles.ImageFileDeletedEvent;
import org.jphototagger.domain.repository.event.imagefiles.ImageFileMovedEvent;
import org.jphototagger.lib.io.FileUtil;
import org.openide.util.Lookup;

public final class IptcIgnoreCache {
    private final File CACHE_DIR = this.lookupCacheDirectory();
    private static final Logger LOGGER = Logger.getLogger(IptcIgnoreCache.class.getName());
    private static final String FILE_CONTENT = "";
    public static final IptcIgnoreCache INSTANCE = new IptcIgnoreCache();

    public boolean isIgnore(File imageFile) {
        if (!this.isDisplayIptc()) {
            return true;
        }
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        boolean ignore = this.containsUpToDateIgnoreInfo(imageFile);
        if (ignore) {
            LOGGER.log(Level.FINEST, "IPTC Ignore Cache: Ignore reading IPTC from image file ''{0}''", imageFile);
        }
        return ignore;
    }

    private boolean isDisplayIptc() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        return prefs.getBoolean("UserSettings.DisplayIptc");
    }

    public void setIgnore(File imageFile, boolean ignore) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        File cacheFile = this.getCacheFile(imageFile);
        if (ignore) {
            this.ignore(imageFile, cacheFile);
        } else {
            this.unIgnore(imageFile, cacheFile);
        }
    }

    private void ignore(File imageFile, File cacheFile) {
        try {
            LOGGER.log(Level.FINEST, "IPTC Ignore Cache: Ignore reading IPTC from image file ''{0}'' (Creating ''{1}'')", new Object[]{imageFile, cacheFile});
            FileUtil.writeStringAsFile((String)FILE_CONTENT, (File)cacheFile);
            FileUtil.touch((File)cacheFile, (File)imageFile);
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.SEVERE, null, throwable);
        }
    }

    private void unIgnore(File imageFile, File cacheFile) {
        if (cacheFile.isFile()) {
            LOGGER.log(Level.FINEST, "IPTC Ignore Cache: Don''t ignore reading IPTC from image file ''{0}'' (Deleting ''{1}'')", new Object[]{imageFile, cacheFile});
            cacheFile.delete();
        }
    }

    private boolean containsIgnoreInfo(File imageFile) {
        return this.getCacheFile(imageFile).isFile();
    }

    private boolean containsUpToDateIgnoreInfo(File imageFile) {
        if (!this.containsIgnoreInfo(imageFile)) {
            return false;
        }
        File cacheFile = this.getCacheFile(imageFile);
        long timestampImageFile = imageFile.lastModified();
        long timestampCachedFile = cacheFile.lastModified();
        return timestampCachedFile == timestampImageFile;
    }

    public int clear() {
        File[] cacheFiles = this.CACHE_DIR.listFiles();
        if (cacheFiles == null || cacheFiles.length == 0) {
            return 0;
        }
        LOGGER.log(Level.INFO, "IPTC Ignore Cache: Deleting all cache files in directory ''{0}''", this.CACHE_DIR);
        int deleteCount = 0;
        for (File cacheFile : cacheFiles) {
            boolean deleted = cacheFile.delete();
            if (deleted) {
                ++deleteCount;
                continue;
            }
            LOGGER.log(Level.WARNING, "IPTC Ignore Cache: Couldn''t delete cache file ''{0}''", cacheFile);
        }
        return deleteCount;
    }

    public int getSize() {
        File[] cacheFiles = this.CACHE_DIR.listFiles();
        return cacheFiles == null ? 0 : cacheFiles.length;
    }

    private File getCacheFile(File imageFile) {
        return new File(this.CACHE_DIR + File.separator + FileUtil.getMd5FilenameOfAbsolutePath((File)imageFile));
    }

    @EventSubscriber(eventClass=ImageFileMovedEvent.class)
    public void imageFileMoved(ImageFileMovedEvent event) {
        File oldImageFile = event.getOldImageFile();
        File newImageFile = event.getNewImageFile();
        File oldCacheFile = this.getCacheFile(oldImageFile);
        if (oldCacheFile.exists()) {
            File newCacheFile = this.getCacheFile(newImageFile);
            LOGGER.log(Level.FINEST, "IPTC Ignore Cache: Renaming IPTC ignore info for image file ''{0}'' renamed to ''{1}'' from ''{2}'' into ''{3}''", new Object[]{oldImageFile, newImageFile, oldCacheFile, newCacheFile});
            oldCacheFile.renameTo(newCacheFile);
        }
    }

    @EventSubscriber(eventClass=ImageFileDeletedEvent.class)
    public void imageFileRemoved(ImageFileDeletedEvent event) {
        File deletedImageFile = event.getImageFile();
        File cacheFile = this.getCacheFile(deletedImageFile);
        if (cacheFile.exists()) {
            this.unIgnore(deletedImageFile, cacheFile);
        }
    }

    public void init() {
        AnnotationProcessor.process((Object)this);
    }

    private IptcIgnoreCache() {
        this.ensureCacheDiretoryExists();
    }

    private File lookupCacheDirectory() {
        CacheDirectoryProvider provider = (CacheDirectoryProvider)Lookup.getDefault().lookup(CacheDirectoryProvider.class);
        return provider.getCacheDirectory("IptcIgnoreCache");
    }

    private void ensureCacheDiretoryExists() {
        if (!this.CACHE_DIR.isDirectory()) {
            try {
                LOGGER.log(Level.FINEST, "IPTC Ignore Cache: Creating cache directory ''{0}''", this.CACHE_DIR);
                FileUtil.ensureDirectoryExists((File)this.CACHE_DIR);
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.SEVERE, null, throwable);
            }
        }
    }
}

