/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.iptc;

import com.imagero.reader.iptc.IPTCEntry;
import com.imagero.reader.iptc.IPTCEntryMeta;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.lib.util.StringUtil;
import org.openide.util.Lookup;

public final class IptcEntry {
    private final String name;
    private final byte[] data;
    private final int recordNumber;
    private final int datasetNumber;
    private final IPTCEntryMeta entryMeta;

    public IptcEntry(IPTCEntry entry) {
        if (entry == null) {
            throw new NullPointerException("entry == null");
        }
        this.name = entry.getEntryMeta().getName();
        this.data = Arrays.copyOf(entry.getData(), entry.getData().length);
        this.recordNumber = entry.getRecordNumber();
        this.datasetNumber = entry.getDataSetNumber();
        this.entryMeta = entry.getEntryMeta();
    }

    public String getName() {
        return this.name;
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public String getData() {
        return this.getEncodedData();
    }

    public int getDataSetNumber() {
        return this.datasetNumber;
    }

    public IPTCEntryMeta getEntryMeta() {
        return this.entryMeta;
    }

    public boolean equals(Object o) {
        if (o instanceof IptcEntry) {
            IptcEntry otherEntry = (IptcEntry)o;
            return this.recordNumber == otherEntry.recordNumber && this.datasetNumber == otherEntry.datasetNumber && this.getData().equals(otherEntry.getData());
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + this.recordNumber;
        hash = 83 * hash + this.datasetNumber;
        return hash;
    }

    private String getEncodedData() {
        try {
            Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
            String iptcCharset = prefs.getString("UserSettings.IptcCharset");
            if (!StringUtil.hasContent((String)iptcCharset)) {
                iptcCharset = "ISO-8859-1";
            }
            String encodedData = new String(this.data, iptcCharset);
            return encodedData.trim();
        }
        catch (Throwable t) {
            Logger.getLogger(IptcEntry.class.getName()).log(Level.SEVERE, null, t);
            return "";
        }
    }
}

