/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.tag;

import org.jphototagger.lib.util.ByteUtil;

public final class ExifGpsVersion {
    private int first = Integer.MIN_VALUE;
    private int second = Integer.MIN_VALUE;
    private int third = Integer.MIN_VALUE;
    private int fourth = Integer.MIN_VALUE;

    public ExifGpsVersion(int first, int second, int third, int fourth) {
        this.first = first;
        this.second = second;
        this.third = third;
        this.fourth = fourth;
    }

    public ExifGpsVersion(byte[] rawValue) {
        if (rawValue != null && ExifGpsVersion.isRawValueByteCountOk(rawValue)) {
            this.first = ByteUtil.toInt((byte)rawValue[0]);
            this.second = ByteUtil.toInt((byte)rawValue[1]);
            this.third = ByteUtil.toInt((byte)rawValue[2]);
            this.fourth = ByteUtil.toInt((byte)rawValue[3]);
        }
    }

    public static int getRawValueByteCount() {
        return 4;
    }

    public static boolean isRawValueByteCountOk(byte[] rawValue) {
        return rawValue == null ? false : rawValue.length == ExifGpsVersion.getRawValueByteCount();
    }

    public int first() {
        return this.first;
    }

    public int fourth() {
        return this.fourth;
    }

    public int second() {
        return this.second;
    }

    public int third() {
        return this.third;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(6);
        sb.append(Integer.toString(this.first)).append(".");
        sb.append(Integer.toString(this.second)).append(".");
        sb.append(Integer.toString(this.third)).append(".");
        sb.append(Integer.toString(this.fourth));
        return sb.toString();
    }
}

