/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.tag;

import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.exif.ExifTag;
import org.jphototagger.exif.ExifTags;
import org.jphototagger.exif.datatype.ExifRational;
import org.jphototagger.exif.datatype.ExifValueUtil;
import org.jphototagger.exif.tag.ExifDegrees;
import org.jphototagger.exif.tag.ExifGpsAltitude;
import org.jphototagger.exif.tag.ExifGpsDateStamp;
import org.jphototagger.exif.tag.ExifGpsLatitude;
import org.jphototagger.exif.tag.ExifGpsLongitude;
import org.jphototagger.exif.tag.ExifGpsMetadata;
import org.jphototagger.exif.tag.ExifGpsTimeStamp;

public final class ExifGpsUtil {
    public static double convertExifDegreesToDouble(ExifDegrees exifDegrees) {
        if (exifDegrees == null) {
            throw new NullPointerException("exifDegrees == null");
        }
        ExifRational degrees = exifDegrees.getDegrees();
        ExifRational minutes = exifDegrees.getMinutes();
        ExifRational seconds = exifDegrees.getSeconds();
        double degreesDouble = ExifValueUtil.convertExifRationalToDouble(degrees);
        double minutesDouble = ExifValueUtil.convertExifRationalToDouble(minutes);
        double secondsDouble = ExifValueUtil.convertExifRationalToDouble(seconds);
        return degreesDouble + minutesDouble / 60.0 + secondsDouble / 3600.0;
    }

    public static double getSecondsOfMinutes(ExifRational minutes) {
        if (minutes == null) {
            throw new NullPointerException("minutes == null");
        }
        double doubleMinutes = ExifValueUtil.convertExifRationalToDouble(minutes);
        double integerMinutes = ExifValueUtil.convertExifRationalToLong(minutes);
        return (doubleMinutes - integerMinutes) * 60.0;
    }

    public static String getDegreesAsString(ExifDegrees exifDegrees) {
        if (exifDegrees == null) {
            throw new NullPointerException("exifDegrees == null");
        }
        MessageFormat msg = new MessageFormat("{0}\u00b0 {1}'' {2}''''");
        ExifRational exifDeg = exifDegrees.getDegrees();
        ExifRational exifMinutes = exifDegrees.getMinutes();
        ExifRational exifSeconds = exifDegrees.getSeconds();
        double degrees = ExifValueUtil.convertExifRationalToDouble(exifDeg);
        double minutes = ExifValueUtil.convertExifRationalToDouble(exifMinutes);
        double seconds = ExifValueUtil.convertExifRationalToDouble(exifSeconds);
        if (seconds == 0.0) {
            minutes = ExifValueUtil.convertExifRationalToLong(exifMinutes);
            seconds = ExifGpsUtil.getSecondsOfMinutes(exifMinutes);
        }
        DecimalFormat decmailFormatMinutes = new DecimalFormat("#");
        DecimalFormat decimalFormatSeconds = new DecimalFormat("#.##");
        String degreesFormatted = decmailFormatMinutes.format(degrees);
        String minutesFormatted = decmailFormatMinutes.format(minutes);
        String secondsFormatted = decimalFormatSeconds.format(seconds);
        Object[] params = new Object[]{degreesFormatted, minutesFormatted, secondsFormatted};
        return msg.format(params);
    }

    public static String getGoogleMapsUrl(ExifGpsLongitude exifGpsLongitude, ExifGpsLatitude exifGpsLatitude) {
        if (exifGpsLongitude == null) {
            throw new NullPointerException("exifGpsLongitude == null");
        }
        if (exifGpsLatitude == null) {
            throw new NullPointerException("exifGpsLatitude == null");
        }
        String language = Locale.getDefault().getLanguage();
        MessageFormat msg = new MessageFormat("http://maps.google.com/maps?q={0},{1}&spn=0.001,0.001&t=k&hl=" + language);
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);
        decimalFormat.applyPattern("#.########");
        double latititude = ExifGpsUtil.convertExifDegreesToDouble(exifGpsLatitude.getExifDegrees());
        double longitude = ExifGpsUtil.convertExifDegreesToDouble(exifGpsLongitude.getExifDegrees());
        ExifGpsLatitude.Ref latitudeRef = exifGpsLatitude.getRef();
        ExifGpsLongitude.Ref longitudeRef = exifGpsLongitude.getRef();
        boolean isSouth = latitudeRef.isSouth();
        boolean isWest = longitudeRef.isWest();
        if (isSouth) {
            latititude *= -1.0;
        }
        if (isWest) {
            longitude *= -1.0;
        }
        Object[] params = new Object[]{decimalFormat.format(latititude), decimalFormat.format(longitude)};
        return msg.format(params);
    }

    public static String getOpenStreetMapUrl(ExifGpsLongitude exifGpsLongitude, ExifGpsLatitude exifGpsLatitude) {
        if (exifGpsLongitude == null) {
            throw new NullPointerException("exifGpsLongitude == null");
        }
        if (exifGpsLatitude == null) {
            throw new NullPointerException("exifGpsLatitude == null");
        }
        MessageFormat msg = new MessageFormat("http://www.openstreetmap.org/?mlat={0}&mlon={1}");
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);
        decimalFormat.applyPattern("#.########");
        double latititude = ExifGpsUtil.convertExifDegreesToDouble(exifGpsLatitude.getExifDegrees());
        double longitude = ExifGpsUtil.convertExifDegreesToDouble(exifGpsLongitude.getExifDegrees());
        ExifGpsLatitude.Ref latitudeRef = exifGpsLatitude.getRef();
        ExifGpsLongitude.Ref longitudeRef = exifGpsLongitude.getRef();
        boolean isSouth = latitudeRef.isSouth();
        boolean isWest = longitudeRef.isWest();
        if (isSouth) {
            latititude *= -1.0;
        }
        if (isWest) {
            longitude *= -1.0;
        }
        Object[] params = new Object[]{decimalFormat.format(latititude), decimalFormat.format(longitude)};
        return msg.format(params);
    }

    public static ExifGpsMetadata createGpsMetadataFromExifTags(ExifTags exifTags) {
        if (exifTags == null) {
            throw new NullPointerException("exifTags == null");
        }
        ExifGpsMetadata exifGpsMetaData = new ExifGpsMetadata();
        ExifGpsUtil.setGpsLatitudeFromExifTagsToExifGpsMetadata(exifTags, exifGpsMetaData);
        ExifGpsUtil.setGpsLongitudeFromExifTagsToExifGpsMetadata(exifTags, exifGpsMetaData);
        ExifGpsUtil.setGpsAltitudeFromExifTagsToExifGpsMetadata(exifTags, exifGpsMetaData);
        ExifGpsUtil.setGpsDateFromExifTagsToExifGpsMetadata(exifTags, exifGpsMetaData);
        ExifGpsUtil.setGpsTimeFromExifTagsToExifGpsMetadata(exifTags, exifGpsMetaData);
        return exifGpsMetaData;
    }

    public static Calendar getGpsTimeFromExifGpsMetadata(ExifGpsMetadata exifGpsMetaData) {
        if (exifGpsMetaData == null) {
            throw new NullPointerException("exifGpsMetaData == null");
        }
        ExifGpsDateStamp dateStamp = exifGpsMetaData.getGpsDateStamp();
        ExifGpsTimeStamp timeStamp = exifGpsMetaData.getTimeStamp();
        if (dateStamp != null && timeStamp != null && dateStamp.isValid()) {
            try {
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                cal.set(1, dateStamp.getYear());
                cal.set(2, dateStamp.getMonth() - 1);
                cal.set(5, dateStamp.getDay());
                cal.set(11, (int)ExifValueUtil.convertExifRationalToDouble(timeStamp.getHours()));
                cal.set(12, (int)ExifValueUtil.convertExifRationalToDouble(timeStamp.getMinutes()));
                cal.set(13, (int)ExifValueUtil.convertExifRationalToDouble(timeStamp.getSeconds()));
                return cal;
            }
            catch (Throwable t) {
                Logger.getLogger(ExifGpsUtil.class.getName()).log(Level.SEVERE, null, t);
            }
        }
        return null;
    }

    private static void setGpsLongitudeFromExifTagsToExifGpsMetadata(ExifTags exifTags, ExifGpsMetadata exifGpsMetaData) {
        ExifTag tagLongitudeRef = exifTags.findGpsTagByTagId(ExifTag.Properties.GPS_LONGITUDE_REF.getTagId());
        ExifTag tagLongitude = exifTags.findGpsTagByTagId(ExifTag.Properties.GPS_LONGITUDE.getTagId());
        if (tagLongitudeRef != null && tagLongitude != null) {
            byte[] refRawValue = tagLongitudeRef.getRawValue();
            byte[] degreesRawValue = tagLongitude.getRawValue();
            ByteOrder byteOrder = tagLongitude.convertByteOrderIdToByteOrder();
            ExifGpsLongitude longitude = new ExifGpsLongitude(refRawValue, degreesRawValue, byteOrder);
            exifGpsMetaData.setLongitude(longitude);
        }
    }

    private static void setGpsLatitudeFromExifTagsToExifGpsMetadata(ExifTags exifTags, ExifGpsMetadata exifGpsMetaData) {
        ExifTag tagLatitudeRef = exifTags.findGpsTagByTagId(ExifTag.Properties.GPS_LATITUDE_REF.getTagId());
        ExifTag tagLatitude = exifTags.findGpsTagByTagId(ExifTag.Properties.GPS_LATITUDE.getTagId());
        if (tagLatitudeRef != null && tagLatitude != null) {
            byte[] refRawValue = tagLatitudeRef.getRawValue();
            byte[] degreesRawValue = tagLatitude.getRawValue();
            ByteOrder byteOrder = tagLatitude.convertByteOrderIdToByteOrder();
            ExifGpsLatitude latitude = new ExifGpsLatitude(refRawValue, degreesRawValue, byteOrder);
            exifGpsMetaData.setLatitude(latitude);
        }
    }

    private static void setGpsAltitudeFromExifTagsToExifGpsMetadata(ExifTags exifTags, ExifGpsMetadata exifGpsMetaData) {
        ExifTag tagAltitudeRef = exifTags.findGpsTagByTagId(ExifTag.Properties.GPS_ALTITUDE_REF.getTagId());
        ExifTag tagAltitude = exifTags.findGpsTagByTagId(ExifTag.Properties.GPS_ALTITUDE.getTagId());
        if (tagAltitudeRef != null && tagAltitude != null) {
            byte[] refRawValue = tagAltitudeRef.getRawValue();
            byte[] rawValue = tagAltitude.getRawValue();
            ByteOrder byteOrder = tagAltitude.convertByteOrderIdToByteOrder();
            ExifGpsAltitude altitude = new ExifGpsAltitude(refRawValue, rawValue, byteOrder);
            exifGpsMetaData.setAltitude(altitude);
        }
    }

    private static void setGpsDateFromExifTagsToExifGpsMetadata(ExifTags exifTags, ExifGpsMetadata exifGpsMetaData) {
        byte[] rawValue;
        ExifTag tagDate = exifTags.findGpsTagByTagId(ExifTag.Properties.GPS_DATE_STAMP.getTagId());
        if (tagDate != null && (rawValue = tagDate.getRawValue()) != null && rawValue.length == 11) {
            ExifGpsDateStamp dateStamp = new ExifGpsDateStamp(rawValue);
            exifGpsMetaData.setGpsDateStamp(dateStamp);
        }
    }

    private static void setGpsTimeFromExifTagsToExifGpsMetadata(ExifTags exifTags, ExifGpsMetadata exifGpsMetaData) {
        byte[] rawValue;
        ExifTag tagTime = exifTags.findGpsTagByTagId(ExifTag.Properties.GPS_TIME_STAMP.getTagId());
        if (tagTime != null && (rawValue = tagTime.getRawValue()) != null && rawValue.length == 24) {
            ByteOrder byteOrder = tagTime.convertByteOrderIdToByteOrder();
            byte[] hoursRawValue = Arrays.copyOfRange(rawValue, 0, 8);
            byte[] minutesRawValue = Arrays.copyOfRange(rawValue, 8, 16);
            byte[] secondsRawValue = Arrays.copyOfRange(rawValue, 16, 24);
            ExifRational hours = new ExifRational(hoursRawValue, byteOrder);
            ExifRational minutes = new ExifRational(minutesRawValue, byteOrder);
            ExifRational seconds = new ExifRational(secondsRawValue, byteOrder);
            ExifGpsTimeStamp timeStamp = new ExifGpsTimeStamp(hours, minutes, seconds);
            exifGpsMetaData.setTimeStamp(timeStamp);
        }
    }

    private ExifGpsUtil() {
    }
}

