/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.tag;

import java.nio.ByteOrder;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.jphototagger.exif.tag.ExifDegrees;
import org.jphototagger.exif.tag.ExifGpsUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.ByteUtil;

public final class ExifGpsLongitude {
    private static final Map<String, Ref> REF_OF_STRING = new HashMap<String, Ref>();
    private static final Map<Ref, String> LOCALIZED_STRING_OF_REF = new EnumMap<Ref, String>(Ref.class);
    private Ref ref;
    private ExifDegrees degrees;

    public ExifGpsLongitude(byte[] refRawValue, byte[] degreesRawValue, ByteOrder byteOrder) {
        if (refRawValue == null) {
            throw new NullPointerException("refRawValue == null");
        }
        if (degreesRawValue == null) {
            throw new NullPointerException("degreesRawValue == null");
        }
        if (byteOrder == null) {
            throw new NullPointerException("byteOrder == null");
        }
        this.ensureByteCount(refRawValue, degreesRawValue);
        this.ref = ExifGpsLongitude.convertRawValueToRef(refRawValue);
        this.degrees = new ExifDegrees(degreesRawValue, byteOrder);
    }

    private static Ref convertRawValueToRef(byte[] rawValue) {
        String s = null;
        if (rawValue != null && rawValue.length == 2) {
            s = new StringBuilder(1).append((char)ByteUtil.toInt((byte)rawValue[0])).toString();
        }
        return REF_OF_STRING.get(s);
    }

    public static int getRefByteCount() {
        return 2;
    }

    public static int getRawValueByteCount() {
        return 24;
    }

    public static boolean isRawValueByteCountOk(byte[] rawValue) {
        return rawValue == null ? false : rawValue.length == ExifGpsLongitude.getRawValueByteCount();
    }

    public static boolean refByteCountOk(byte[] rawValue) {
        return rawValue == null ? false : rawValue.length == ExifGpsLongitude.getRefByteCount();
    }

    public String toLocalizedString() {
        return ExifGpsUtil.getDegreesAsString(this.degrees) + " " + LOCALIZED_STRING_OF_REF.get((Object)this.ref);
    }

    public ExifDegrees getExifDegrees() {
        return this.degrees;
    }

    public Ref getRef() {
        return this.ref;
    }

    private void ensureByteCount(byte[] refRawValue, byte[] degreesRawValue) throws IllegalArgumentException {
        if (!ExifGpsLongitude.refByteCountOk(refRawValue)) {
            throw new IllegalArgumentException("Illegal ref raw value byte count: " + refRawValue.length);
        }
        if (!ExifGpsLongitude.isRawValueByteCountOk(degreesRawValue)) {
            throw new IllegalArgumentException("Illegal raw value byte count: " + degreesRawValue.length);
        }
    }

    static {
        REF_OF_STRING.put("E", Ref.EAST);
        REF_OF_STRING.put("W", Ref.WEST);
        LOCALIZED_STRING_OF_REF.put(Ref.EAST, Bundle.getString(ExifGpsLongitude.class, (String)"ExifGpsLongitudeRefEast", (Object[])new Object[0]));
        LOCALIZED_STRING_OF_REF.put(Ref.WEST, Bundle.getString(ExifGpsLongitude.class, (String)"ExifGpsLongitudeRefWest", (Object[])new Object[0]));
    }

    public static enum Ref {
        EAST,
        WEST;


        public boolean isWest() {
            return this.equals((Object)WEST);
        }

        public boolean isEast() {
            return this.equals((Object)EAST);
        }
    }
}

