/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.tag;

import java.nio.ByteOrder;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.jphototagger.exif.tag.ExifDegrees;
import org.jphototagger.exif.tag.ExifGpsUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.ByteUtil;

public final class ExifGpsLatitude {
    private static final Map<String, Ref> REF_OF_STRING = new HashMap<String, Ref>();
    private static final Map<Ref, String> LOCALIZED_STRING_OF_REF = new EnumMap<Ref, String>(Ref.class);
    private Ref ref;
    private ExifDegrees degrees;

    public ExifGpsLatitude(byte[] refRawValue, byte[] degreesRawValue, ByteOrder byteOrder) {
        if (refRawValue == null) {
            throw new NullPointerException("refRawValue == null");
        }
        if (degreesRawValue == null) {
            throw new NullPointerException("degreesRawValue == null");
        }
        if (byteOrder == null) {
            throw new NullPointerException("byteOrder == null");
        }
        this.ensureByteCount(refRawValue, degreesRawValue);
        this.ref = ExifGpsLatitude.convertRawValueToRef(refRawValue);
        this.degrees = new ExifDegrees(degreesRawValue, byteOrder);
    }

    private static Ref convertRawValueToRef(byte[] rawValue) {
        String s = null;
        if (rawValue != null && rawValue.length == 2) {
            s = new StringBuilder(1).append((char)ByteUtil.toInt((byte)rawValue[0])).toString();
        }
        return REF_OF_STRING.get(s);
    }

    public static int getRawValueByteCount() {
        return 24;
    }

    public static int getRefByteCount() {
        return 2;
    }

    public static boolean isRawValueByteCountOk(byte[] rawValue) {
        return rawValue == null ? false : rawValue.length == ExifGpsLatitude.getRawValueByteCount();
    }

    public static boolean isRefByteCountOk(byte[] rawValue) {
        return rawValue == null ? false : rawValue.length == ExifGpsLatitude.getRefByteCount();
    }

    public String getLocalizedString() {
        return ExifGpsUtil.getDegreesAsString(this.degrees) + " " + LOCALIZED_STRING_OF_REF.get((Object)this.ref);
    }

    public ExifDegrees getExifDegrees() {
        return this.degrees;
    }

    public Ref getRef() {
        return this.ref;
    }

    private void ensureByteCount(byte[] refRawValue, byte[] degreesRawValue) throws IllegalArgumentException {
        if (!ExifGpsLatitude.isRefByteCountOk(refRawValue)) {
            throw new IllegalArgumentException("Illegal ref raw value byte count: " + refRawValue.length);
        }
        if (!ExifGpsLatitude.isRawValueByteCountOk(degreesRawValue)) {
            throw new IllegalArgumentException("Illegal raw value byte count: " + degreesRawValue.length);
        }
    }

    static {
        REF_OF_STRING.put("N", Ref.NORTH);
        REF_OF_STRING.put("S", Ref.SOUTH);
        LOCALIZED_STRING_OF_REF.put(Ref.NORTH, Bundle.getString(ExifGpsLatitude.class, (String)"ExifGpsLatitudeRefNorth", (Object[])new Object[0]));
        LOCALIZED_STRING_OF_REF.put(Ref.SOUTH, Bundle.getString(ExifGpsLatitude.class, (String)"ExifGpsLatitudeRefSouth", (Object[])new Object[0]));
    }

    public static enum Ref {
        NORTH,
        SOUTH;


        public boolean isNorth() {
            return this.equals((Object)NORTH);
        }

        public boolean isSouth() {
            return this.equals((Object)SOUTH);
        }
    }
}

