/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.tag;

import java.util.logging.Level;
import java.util.logging.Logger;

public final class ExifGpsDateStamp {
    private static final int UNDEFINED = Integer.MIN_VALUE;
    private final String stringValue;
    private int year = Integer.MIN_VALUE;
    private int month = Integer.MIN_VALUE;
    private int day = Integer.MIN_VALUE;

    public ExifGpsDateStamp(byte[] rawValue) {
        if (rawValue == null) {
            throw new NullPointerException("rawValue == null");
        }
        if (rawValue.length != 11) {
            throw new IllegalArgumentException("length of raw value != 11: " + rawValue.length);
        }
        this.stringValue = new String(rawValue).substring(0, 10);
        this.setIntegerValues();
    }

    private void unsetIntegerValues() {
        this.year = Integer.MIN_VALUE;
        this.month = Integer.MIN_VALUE;
        this.day = Integer.MIN_VALUE;
    }

    private void setIntegerValues() {
        String yearString = this.stringValue.substring(0, 4);
        String monthString = this.stringValue.substring(5, 7);
        String dayString = this.stringValue.substring(8, 10);
        try {
            this.year = Integer.parseInt(yearString);
            this.month = Integer.parseInt(monthString);
            this.day = Integer.parseInt(dayString);
        }
        catch (Throwable t) {
            Logger.getLogger(ExifGpsDateStamp.class.getName()).log(Level.SEVERE, null, t);
            this.unsetIntegerValues();
        }
    }

    public int getDay() {
        if (!this.isValid()) {
            throw new IllegalStateException("date couldn't be set properly");
        }
        return this.day;
    }

    public int getMonth() {
        if (!this.isValid()) {
            throw new IllegalStateException("date couldn't be set properly");
        }
        return this.month;
    }

    public int getYear() {
        if (!this.isValid()) {
            throw new IllegalStateException("date couldn't be set properly");
        }
        return this.year;
    }

    public boolean isValid() {
        return this.year != Integer.MIN_VALUE && this.month != Integer.MIN_VALUE && this.day != Integer.MIN_VALUE;
    }

    public String toString() {
        return this.stringValue;
    }
}

