/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.tag;

import java.nio.ByteOrder;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.jphototagger.exif.datatype.ExifRational;
import org.jphototagger.exif.datatype.ExifValueUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.ByteUtil;

public final class ExifGpsAltitude {
    private static final Map<Integer, Ref> REF_OF_INTEGER = new HashMap<Integer, Ref>();
    private static final Map<Ref, String> LOCALIZED_STRING_OF_REF = new EnumMap<Ref, String>(Ref.class);
    private Ref ref;
    private ExifRational value;

    public ExifGpsAltitude(byte[] refRawValue, byte[] rawValue, ByteOrder byteOrder) {
        if (refRawValue == null) {
            throw new NullPointerException("refRawValue == null");
        }
        if (rawValue == null) {
            throw new NullPointerException("rawValue == null");
        }
        if (byteOrder == null) {
            throw new NullPointerException("byteOrder == null");
        }
        this.ensureByteCount(refRawValue, rawValue);
        this.ref = ExifGpsAltitude.convertRawValueToRef(refRawValue);
        this.value = new ExifRational(Arrays.copyOfRange(rawValue, 0, 8), byteOrder);
    }

    public static int getRefByteCount() {
        return 1;
    }

    public static int getRawValueByteCount() {
        return 8;
    }

    public static boolean isRawValueByteCountOk(byte[] rawValue) {
        return rawValue == null ? false : rawValue.length == ExifGpsAltitude.getRawValueByteCount();
    }

    public static boolean isRefByteCountOk(byte[] rawValue) {
        return rawValue == null ? false : rawValue.length == ExifGpsAltitude.getRefByteCount();
    }

    private static Ref convertRawValueToRef(byte[] rawValue) {
        return REF_OF_INTEGER.get(ByteUtil.toInt((byte)rawValue[0]));
    }

    public String getLocalizedString() {
        MessageFormat msg = new MessageFormat("{0} m {1}");
        return msg.format(new Object[]{ExifValueUtil.convertExifRationalToLong(this.value), LOCALIZED_STRING_OF_REF.get((Object)this.ref)});
    }

    public Ref getRef() {
        return this.ref;
    }

    public ExifRational getValue() {
        return this.value;
    }

    private void ensureByteCount(byte[] refRawValue, byte[] rawValue) throws IllegalArgumentException {
        if (!ExifGpsAltitude.isRefByteCountOk(refRawValue)) {
            throw new IllegalArgumentException("Illegal ref raw value byte count: " + refRawValue.length);
        }
        if (!ExifGpsAltitude.isRawValueByteCountOk(rawValue)) {
            throw new IllegalArgumentException("Illegal raw value byte count: " + rawValue.length);
        }
    }

    static {
        REF_OF_INTEGER.put(0, Ref.OBOVE_SEA_LEVEL);
        REF_OF_INTEGER.put(1, Ref.BELOW_SEA_LEVEL);
        LOCALIZED_STRING_OF_REF.put(Ref.OBOVE_SEA_LEVEL, Bundle.getString(ExifGpsAltitude.class, (String)"ExifGpsAltitudeRefOboveSeaLevel", (Object[])new Object[0]));
        LOCALIZED_STRING_OF_REF.put(Ref.BELOW_SEA_LEVEL, Bundle.getString(ExifGpsAltitude.class, (String)"ExifGpsAltitudeRefBelowSeaLevel", (Object[])new Object[0]));
    }

    public static enum Ref {
        OBOVE_SEA_LEVEL,
        BELOW_SEA_LEVEL;

    }
}

