/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.tag;

import java.nio.ByteOrder;
import java.util.Arrays;
import org.jphototagger.exif.Ensure;
import org.jphototagger.exif.datatype.ExifRational;

public final class ExifDegrees {
    private final ExifRational degrees;
    private final ExifRational minutes;
    private final ExifRational seconds;

    public ExifDegrees(byte[] rawValue, ByteOrder byteOrder) {
        if (rawValue == null) {
            throw new NullPointerException("rawValue == null");
        }
        if (byteOrder == null) {
            throw new NullPointerException("byteOrder == null");
        }
        Ensure.length(rawValue, ExifDegrees.getRawValueByteCount());
        this.degrees = new ExifRational(Arrays.copyOfRange(rawValue, 0, 8), byteOrder);
        this.minutes = new ExifRational(Arrays.copyOfRange(rawValue, 8, 16), byteOrder);
        this.seconds = new ExifRational(Arrays.copyOfRange(rawValue, 16, 24), byteOrder);
    }

    public static int getRawValueByteCount() {
        return 24;
    }

    public boolean isRawValueByteCountOk(byte[] rawValue) {
        return rawValue == null ? false : rawValue.length == ExifDegrees.getRawValueByteCount();
    }

    public ExifRational getDegrees() {
        return this.degrees;
    }

    public ExifRational getMinutes() {
        return this.minutes;
    }

    public ExifRational getSeconds() {
        return this.seconds;
    }
}

