/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.tag;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.jphototagger.lib.util.NumberRange;

public final class ExifCopyright {
    private final String photographerCopyright;
    private final String editorCopyright;

    public ExifCopyright(byte[] photographerCopyright, byte[] editorCopyright) {
        if (photographerCopyright == null) {
            throw new NullPointerException("photographerCopyright == null");
        }
        if (editorCopyright == null) {
            throw new NullPointerException("editorCopyright == null");
        }
        this.photographerCopyright = ExifCopyright.convertRawValueToPhotographerCopyright(photographerCopyright);
        this.editorCopyright = ExifCopyright.convertRawValueToEditorCopyright(editorCopyright);
    }

    public String getEditorCopyright() {
        return this.editorCopyright;
    }

    public String getPhotographerCopyright() {
        return this.photographerCopyright;
    }

    public static String convertRawValueToPhotographerCopyright(byte[] rawValue) {
        if (rawValue == null) {
            throw new NullPointerException("rawValue == null");
        }
        NumberRange<Integer> photographerOffsets = ExifCopyright.findPhotographerOffsetsOfRawValue(rawValue);
        return ExifCopyright.convertRawValueToString(rawValue, (Integer)photographerOffsets.getBegin(), (Integer)photographerOffsets.getEnd());
    }

    public static String convertRawValueToEditorCopyright(byte[] rawValue) {
        if (rawValue == null) {
            throw new NullPointerException("rawValue == null");
        }
        NumberRange<Integer> editorOffsets = ExifCopyright.findEditorOffsetsOfRawValue(rawValue);
        return ExifCopyright.convertRawValueToString(rawValue, (Integer)editorOffsets.getBegin(), (Integer)editorOffsets.getEnd());
    }

    private static String convertRawValueToString(byte[] ba, int first, int last) {
        if (first < 0 || first > ba.length || last < first || last > ba.length) {
            return "";
        }
        return new String(Arrays.copyOfRange(ba, first, last), Charset.forName("US-ASCII"));
    }

    private static NumberRange<Integer> findPhotographerOffsetsOfRawValue(byte[] rawValue) {
        if (rawValue.length < 2) {
            return new NumberRange((Number)-1, (Number)-1);
        }
        boolean end = false;
        int i = 0;
        while (!end && i < rawValue.length) {
            end = rawValue[i++] == 0;
        }
        return new NumberRange((Number)0, (Number)(i - 1));
    }

    private static NumberRange<Integer> findEditorOffsetsOfRawValue(byte[] rawValue) {
        if (rawValue.length < 3) {
            return new NumberRange((Number)-1, (Number)-1);
        }
        NumberRange<Integer> photographerOffsets = ExifCopyright.findPhotographerOffsetsOfRawValue(rawValue);
        if ((Integer)photographerOffsets.getBegin() == -1 || (Integer)photographerOffsets.getEnd() == rawValue.length) {
            return new NumberRange((Number)-1, (Number)-1);
        }
        return new NumberRange((Number)((Integer)photographerOffsets.getEnd() + 1), (Number)(rawValue.length - 1));
    }
}

