/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.kmlexport;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.api.concurrent.Cancelable;
import org.jphototagger.api.concurrent.SerialTaskExecutor;
import org.jphototagger.api.plugin.fileprocessor.FileProcessingFinishedEvent;
import org.jphototagger.api.plugin.fileprocessor.FileProcessingStartedEvent;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressHandle;
import org.jphototagger.api.progress.ProgressHandleFactory;
import org.jphototagger.exif.ExifSupport;
import org.jphototagger.exif.ExifTags;
import org.jphototagger.exif.kmlexport.GPSImageInfo;
import org.jphototagger.exif.kmlexport.GPSLocationExporter;
import org.jphototagger.exif.tag.ExifGpsMetadata;
import org.jphototagger.exif.tag.ExifGpsUtil;
import org.jphototagger.lib.io.IoUtil;
import org.jphototagger.lib.swing.FileChooserExt;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.PreferencesUtil;
import org.openide.util.Lookup;

public final class GPSLocationExportUtil {
    private static final String KEY_CURRENT_DIR = "GPSLocationExportUtil.CurrentDir";

    static String getFilename(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (GPSLocationExportUtil.isAddFilenameToGpsLocationExport()) {
            return " [" + file.getName() + "]";
        }
        return "";
    }

    private static boolean isAddFilenameToGpsLocationExport() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.AddFilenameToGpsLocationExport") ? prefs.getBoolean("UserSettings.AddFilenameToGpsLocationExport") : false;
    }

    static void export(GPSLocationExporter gpsExporter, Collection<? extends File> imageFiles) {
        SerialTaskExecutor executor = (SerialTaskExecutor)Lookup.getDefault().lookup(SerialTaskExecutor.class);
        Exporter exporter = new Exporter(gpsExporter, imageFiles);
        executor.addTask((Runnable)exporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void export(GPSLocationExporter exporter, List<GPSImageInfo> gpsImageInfos) {
        File exportFile = GPSLocationExportUtil.getFile(exporter);
        if (exportFile != null) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(exportFile);
                exporter.export(gpsImageInfos, fos);
                fos.flush();
            }
            catch (Throwable t) {
                try {
                    Logger.getLogger(GPSLocationExportUtil.class.getName()).log(Level.SEVERE, null, t);
                    String message = Bundle.getString(GPSLocationExportUtil.class, (String)"GPSLocationExportUtil.Error.Export", (Object[])new Object[]{exportFile});
                    MessageDisplayer.error(null, (String)message);
                }
                catch (Throwable throwable) {
                    IoUtil.close(fos);
                    throw throwable;
                }
                IoUtil.close((Closeable)fos);
            }
            IoUtil.close((Closeable)fos);
        }
    }

    private static File getFile(GPSLocationExporter exporter) {
        FileChooserExt fileChooser = new FileChooserExt(GPSLocationExportUtil.getCurrentDir());
        fileChooser.setFileFilter(exporter.getFileFilter());
        fileChooser.setConfirmOverwrite(true);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setSaveFilenameExtension(exporter.getFilenameExtension());
        if (fileChooser.showSaveDialog(null) == 0) {
            File file = fileChooser.getSelectedFile();
            GPSLocationExportUtil.setCurrentDir(file);
            return file;
        }
        return null;
    }

    private static synchronized File getCurrentDir() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        String path = prefs.getString(KEY_CURRENT_DIR);
        return new File(path == null ? "" : path);
    }

    private static synchronized void setCurrentDir(File dir) {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        PreferencesUtil.setDirectory((Preferences)prefs, (String)KEY_CURRENT_DIR, (File)dir);
    }

    private GPSLocationExportUtil() {
    }

    private static class Exporter
    extends Thread
    implements Cancelable {
        private volatile boolean cancel;
        private final GPSLocationExporter exporter;
        private final List<? extends File> imageFiles;
        private static final String PROGRESS_BAR_STRING = Bundle.getString(GPSLocationExportUtil.class, (String)"GPSLocationExportUtil.Exporter.Info", (Object[])new Object[0]);
        private ProgressHandle progressHandle;

        Exporter(GPSLocationExporter exporter, Collection<? extends File> imageFiles) {
            super("JPhotoTagger: Exporting GPS locations");
            this.exporter = exporter;
            this.imageFiles = new ArrayList<File>(imageFiles);
        }

        public void cancel() {
            this.cancel = true;
        }

        @Override
        public void run() {
            int fileCount = this.imageFiles.size();
            EventBus.publish((Object)new FileProcessingStartedEvent((Object)this));
            this.progressHandle = ((ProgressHandleFactory)Lookup.getDefault().lookup(ProgressHandleFactory.class)).createProgressHandle((Cancelable)this);
            this.progressHandle.progressStarted(this.createStartProgressEvent(fileCount));
            ArrayList<GPSImageInfo> imageInfos = new ArrayList<GPSImageInfo>(fileCount);
            for (int i = 0; !this.cancel && !this.isInterrupted() && i < fileCount; ++i) {
                File imageFile = this.imageFiles.get(i);
                ExifTags et = ExifSupport.INSTANCE.getExifTagsPreferCached(imageFile);
                if (et != null) {
                    ExifGpsMetadata gpsMetadata = ExifGpsUtil.createGpsMetadataFromExifTags(et);
                    imageInfos.add(new GPSImageInfo(imageFile, gpsMetadata));
                }
                this.progressHandle.progressPerformed(this.createPerformedProgressEvent(fileCount, i + 1));
            }
            GPSLocationExportUtil.export(this.exporter, imageInfos);
            this.createFinishedProgressEvent();
        }

        private ProgressEvent createStartProgressEvent(int maximum) {
            return new ProgressEvent.Builder().source((Object)this).minimum(0).maximum(maximum).value(0).stringPainted(true).stringToPaint(PROGRESS_BAR_STRING).build();
        }

        private ProgressEvent createPerformedProgressEvent(int maximum, int value) {
            return new ProgressEvent.Builder().source((Object)this).minimum(0).maximum(maximum).value(value).stringPainted(true).stringToPaint(PROGRESS_BAR_STRING).build();
        }

        private void createFinishedProgressEvent() {
            this.progressHandle.progressEnded();
            EventBus.publish((Object)new FileProcessingFinishedEvent((Object)this, true));
        }
    }
}

