/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.formatter.nikon;

import com.imagero.reader.tiff.ImageFileDirectory;
import com.imagero.reader.tiff.TiffReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.exif.ExifIfd;
import org.jphototagger.exif.ExifMakerNotes;
import org.jphototagger.exif.ExifTag;
import org.jphototagger.exif.ExifTags;
import org.jphototagger.exif.formatter.nikon.NikonMakerNote;
import org.jphototagger.exif.formatter.nikon.NikonMakerNoteTagIdExifTagId;

public final class NikonMakerNotes
implements ExifMakerNotes {
    private static final String PROPERTY_FILE_PREFIX = "org/jphototagger/exif/formatter/nikon/NikonExifMakerNote_";
    private static final Collection<NikonMakerNote> MAKER_NOTES = new ArrayList<NikonMakerNote>();

    private static NikonMakerNote get(ExifTags exifTags, byte[] rawValue) {
        for (NikonMakerNote makerNote : MAKER_NOTES) {
            if (!makerNote.matches(exifTags, rawValue)) continue;
            return makerNote;
        }
        return null;
    }

    @Override
    public void add(File file, ExifTags exifTags, ExifTag makerNoteTag) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (exifTags == null) {
            throw new NullPointerException("exifTags == null");
        }
        if (makerNoteTag == null) {
            throw new NullPointerException("makerNoteTag == null");
        }
        this.add(makerNoteTag, exifTags);
    }

    private void add(ExifTag exifMakerNote, ExifTags exifTags) {
        assert (exifMakerNote.parseProperties().equals((Object)ExifTag.Properties.MAKER_NOTE));
        NikonMakerNote nikonMakerNote = NikonMakerNotes.get(exifTags, exifMakerNote.getRawValue());
        if (nikonMakerNote == null) {
            return;
        }
        ArrayList<ExifTag> allMakerNoteTags = new ArrayList<ExifTag>();
        int offset = nikonMakerNote.getByteOffsetToIfd();
        try {
            byte[] raw = exifMakerNote.getRawValue();
            byte[] bytes = new byte[raw.length - offset];
            System.arraycopy(raw, offset, bytes, 0, bytes.length);
            TiffReader r = new TiffReader(bytes);
            ImageFileDirectory ifd = r.getIFD(0);
            int count = ifd.getEntryCount();
            for (int i = 0; i < count; ++i) {
                allMakerNoteTags.add(new ExifTag(ifd.getEntryAt(i), ExifIfd.MAKER_NOTE));
            }
            exifTags.addMakerNoteTags(nikonMakerNote.getDisplayableMakerNotesOf(allMakerNoteTags));
            exifTags.setMakerNoteDescription(nikonMakerNote.getDescription());
            NikonMakerNotes.mergeMakerNoteTags(exifTags, nikonMakerNote.getTagIdsEqualInExifIfd());
        }
        catch (Throwable t) {
            Logger.getLogger(NikonMakerNotes.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    private static void mergeMakerNoteTags(ExifTags exifTags, List<NikonMakerNoteTagIdExifTagId> equalTagIds) {
        for (NikonMakerNoteTagIdExifTagId nikonMakerNoteTagIdExifTagId : equalTagIds) {
            ExifTag makerNoteTag = exifTags.findmakerNoteTagByTagId(nikonMakerNoteTagIdExifTagId.getNikonMakerNoteTagId());
            if (makerNoteTag == null) continue;
            ExifTag exifTag = exifTags.findExifTagByTagId(nikonMakerNoteTagIdExifTagId.getExifTagId());
            exifTags.removeFromMakerNoteTags(makerNoteTag);
            if (exifTag != null) continue;
            exifTags.addExifTag(new ExifTag(nikonMakerNoteTagIdExifTagId.getExifTagId(), makerNoteTag.getIntValueType(), makerNoteTag.getValueCount(), makerNoteTag.getValueOffset(), makerNoteTag.getRawValue(), makerNoteTag.getStringValue(), makerNoteTag.getByteOrderId(), makerNoteTag.getName(), ExifIfd.EXIF));
        }
    }

    static {
        int index = 0;
        int maxIndex = 100;
        while (index <= 100) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(PROPERTY_FILE_PREFIX + Integer.toString(index++));
                MAKER_NOTES.add(new NikonMakerNote(bundle));
            }
            catch (Throwable t) {
                index = 101;
            }
        }
    }
}

