/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.formatter.nikon;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.exif.ExifTag;
import org.jphototagger.exif.ExifTags;
import org.jphototagger.exif.datatype.ExifLong;
import org.jphototagger.exif.datatype.ExifRational;
import org.jphototagger.exif.datatype.ExifShort;
import org.jphototagger.exif.formatter.ExifRawValueFormatter;
import org.jphototagger.exif.formatter.nikon.NikonMakerNoteTagIdExifTagId;
import org.jphototagger.lib.util.ArrayUtil;
import org.jphototagger.lib.util.RegexUtil;

public final class NikonMakerNote {
    private final String description;
    private final String exifTagMatchPattern;
    private final int exifMatchTagId;
    private final ResourceBundle bundle;
    private final int byteOffsetToTiffHeader;
    private final byte[][] magicBytePatterns;
    private final List<MakerNoteTagInfo> makerNoteTagInfos = new ArrayList<MakerNoteTagInfo>();
    private final List<NikonMakerNoteTagIdExifTagId> equalTagIdsInExifIfd = new ArrayList<NikonMakerNoteTagIdExifTagId>();
    private static final Collection<Class<?>> BYTE_ORDER_CLASSES = new HashSet();

    NikonMakerNote(ResourceBundle bundle) throws MissingResourceException {
        this.bundle = bundle;
        this.description = bundle.getString("Description");
        this.exifTagMatchPattern = bundle.getString("MatchTagPattern");
        this.exifMatchTagId = Integer.parseInt(bundle.getString("MatchTag"));
        this.byteOffsetToTiffHeader = Integer.parseInt(bundle.getString("ByteOffsetToTiffHeader"));
        StringTokenizer tokenizerAllPatterns = new StringTokenizer(bundle.getString("MagicBytePatterns"), ";");
        int countMagicBytePatterns = tokenizerAllPatterns.countTokens();
        if (countMagicBytePatterns > 0) {
            this.magicBytePatterns = new byte[countMagicBytePatterns][];
            this.setMagicBytePatterns(tokenizerAllPatterns);
        } else {
            this.magicBytePatterns = null;
        }
        this.setMakerNoteTagInfos();
        this.setTagIdsEqualInExifIfd();
    }

    private void setMagicBytePatterns(StringTokenizer tokenizerAllPatterns) {
        int indexMagicBytePatterns = 0;
        while (tokenizerAllPatterns.hasMoreTokens()) {
            StringTokenizer tokenizer = new StringTokenizer(tokenizerAllPatterns.nextToken(), ",");
            int tokenCount = tokenizer.countTokens();
            int tokenIndex = 0;
            if (tokenCount <= 0) {
                throw new IllegalArgumentException("Ivalid magic byte pattern definition!");
            }
            byte[] byteArray = new byte[tokenCount];
            while (tokenizer.hasMoreTokens()) {
                byteArray[tokenIndex++] = Byte.parseByte(tokenizer.nextToken(), 16);
            }
            this.magicBytePatterns[indexMagicBytePatterns++] = byteArray;
        }
    }

    boolean matches(ExifTags exifTags, byte[] makerNoteRawValue) {
        ExifTag exifTag = exifTags.findExifTagByTagId(this.exifMatchTagId);
        if (exifTag == null) {
            return false;
        }
        boolean matches = exifTag.getStringValue().matches(this.exifTagMatchPattern);
        if (this.magicBytePatterns == null) {
            return matches;
        }
        return matches && this.matchesMagicBytePattern(makerNoteRawValue);
    }

    private boolean matchesMagicBytePattern(byte[] makerNoteRawValue) {
        if (this.magicBytePatterns == null) {
            return false;
        }
        for (byte[] bytes : this.magicBytePatterns) {
            byte[] cmpBytes = makerNoteRawValue;
            if (makerNoteRawValue.length > bytes.length) {
                cmpBytes = new byte[bytes.length];
                System.arraycopy(makerNoteRawValue, 0, cmpBytes, 0, bytes.length);
            }
            if (!ArrayUtil.byteArraysEquals((byte[])bytes, (byte[])cmpBytes)) continue;
            return true;
        }
        return false;
    }

    int getByteOffsetToIfd() {
        return this.byteOffsetToTiffHeader;
    }

    String getDescription() {
        return this.description;
    }

    List<NikonMakerNoteTagIdExifTagId> getTagIdsEqualInExifIfd() {
        return Collections.unmodifiableList(this.equalTagIdsInExifIfd);
    }

    List<ExifTag> getDisplayableMakerNotesOf(List<ExifTag> makerNoteTags) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ArrayList<ExifTag> displayableTags = new ArrayList<ExifTag>();
        for (ExifTag exifTag : makerNoteTags) {
            Object valueType;
            Constructor c;
            int pos = this.indexOf(exifTag.getTagId(), this.makerNoteTagInfos);
            if (pos < 0) continue;
            MakerNoteTagInfo info = this.makerNoteTagInfos.get(pos);
            byte[] rawValue = exifTag.getRawValue();
            int offset = info.rawValueOffset;
            int bytesToRead = info.readAllBytes() ? rawValue.length - offset : info.bytesToRead;
            byte[] rawValueMakerNote = new byte[bytesToRead];
            System.arraycopy(rawValue, offset, rawValueMakerNote, 0, bytesToRead);
            Class dataTypeClass = info.exifDataTypeClass;
            if (this.requiresByteOrder(dataTypeClass)) {
                c = dataTypeClass.getConstructor(byte[].class, ByteOrder.class);
                valueType = c.newInstance(rawValueMakerNote, exifTag.convertByteOrderIdToByteOrder());
            } else {
                c = dataTypeClass.getConstructor(byte[].class);
                valueType = c.newInstance(new Object[]{rawValueMakerNote});
            }
            ExifTag makerNoteTag = new ExifTag(exifTag.getTagId(), exifTag.parseValueType().getIntValue(), exifTag.getValueCount(), exifTag.getValueOffset(), rawValueMakerNote, info.hasFormatterClass() ? this.format(info.exifFormatterClass, exifTag) : valueType.toString().trim(), exifTag.getByteOrderId(), this.bundle.getString(info.tagNameBundleKey), exifTag.getIfd());
            displayableTags.add(makerNoteTag);
        }
        return displayableTags;
    }

    private List<String> bundleKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        Enumeration<String> e = this.bundle.getKeys();
        while (e.hasMoreElements()) {
            keys.add(e.nextElement());
        }
        return keys;
    }

    private int indexOfTag(String tag) {
        return Integer.parseInt(tag.substring(3));
    }

    private String format(Class<?> formatterClass, ExifTag exifTag) throws InstantiationException, IllegalAccessException {
        ExifRawValueFormatter formatter = (ExifRawValueFormatter)formatterClass.newInstance();
        return formatter.format(exifTag);
    }

    private int indexOf(int tagIdValue, List<MakerNoteTagInfo> infos) {
        int index = 0;
        for (MakerNoteTagInfo info : infos) {
            if (tagIdValue == info.tagIdValue) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private void setMakerNoteTagInfos() {
        List keys = RegexUtil.getMatches(this.bundleKeys(), (String)"^Tag[0-9]+");
        for (String key : keys) {
            try {
                this.makerNoteTagInfos.add(new MakerNoteTagInfo(this.indexOfTag(key), this.bundle.getString(key)));
            }
            catch (Throwable t) {
                Logger.getLogger(NikonMakerNote.class.getName()).log(Level.SEVERE, null, t);
            }
        }
    }

    private boolean requiresByteOrder(Class<?> clazz) {
        return BYTE_ORDER_CLASSES.contains(clazz);
    }

    private void setTagIdsEqualInExifIfd() {
        for (MakerNoteTagInfo info : this.makerNoteTagInfos) {
            if (!info.equalsToExifTag()) continue;
            this.equalTagIdsInExifIfd.add(new NikonMakerNoteTagIdExifTagId(info.tagIdValue, info.equalsToExifTagId));
        }
    }

    static {
        BYTE_ORDER_CLASSES.add(ExifShort.class);
        BYTE_ORDER_CLASSES.add(ExifRational.class);
        BYTE_ORDER_CLASSES.add(ExifLong.class);
    }

    private static class MakerNoteTagInfo {
        private final int tagIdValue;
        private int rawValueOffset;
        private int bytesToRead = -1;
        private Class<?> exifDataTypeClass;
        private Class<?> exifFormatterClass;
        private String tagNameBundleKey;
        private int equalsToExifTagId = -1;

        private MakerNoteTagInfo(int tagIndex, String propertyValue) throws ClassNotFoundException {
            this.tagIdValue = tagIndex;
            this.tagNameBundleKey = "Tag" + Integer.toString(tagIndex) + "DisplayName";
            this.init(propertyValue);
        }

        private void init(String propertyValue) throws ClassNotFoundException {
            StringTokenizer st = new StringTokenizer(propertyValue, ";");
            int index = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                switch (index++) {
                    case 0: {
                        this.rawValueOffset = Integer.parseInt(token);
                        break;
                    }
                    case 1: {
                        this.bytesToRead = token.equals("all") ? -1 : Integer.parseInt(token);
                        break;
                    }
                    case 2: {
                        this.exifDataTypeClass = Class.forName(token);
                        break;
                    }
                    case 3: {
                        this.exifFormatterClass = token.equals("null") ? null : Class.forName(token);
                        break;
                    }
                    case 4: {
                        this.equalsToExifTagId = token.isEmpty() ? -1 : Integer.parseInt(token);
                    }
                }
            }
        }

        public boolean hasFormatterClass() {
            return this.exifFormatterClass != null;
        }

        public boolean equalsToExifTag() {
            return this.equalsToExifTagId > 0;
        }

        public boolean readAllBytes() {
            return this.bytesToRead <= 0;
        }
    }
}

