/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.formatter.canon;

import java.text.DecimalFormat;
import org.jphototagger.exif.ExifTags;
import org.jphototagger.exif.formatter.canon.CanonMakerNotes;

final class CanonMakerNoteTag4Formatter {
    private static final int CANON_TAG = 4;

    static void add(short[] values, ExifTags exifTags) {
        CanonMakerNoteTag4Formatter.addSubjectDistance(values, exifTags);
    }

    private static void addSubjectDistance(short[] values, ExifTags exifTags) {
        int offset = 19;
        int valueIndex = 18;
        if (18 >= values.length) {
            return;
        }
        short distance = values[18];
        if (distance <= 0) {
            return;
        }
        double factor = distance / 1000 >= 1 ? 1000.0 : 100.0;
        double distanceM = (double)distance / factor;
        double distanceCm = (double)distance / factor / 100.0;
        DecimalFormat dfCm = new DecimalFormat("#.## cm");
        DecimalFormat dfM = new DecimalFormat("#.# m");
        String d = distanceM >= 1.0 ? dfM.format(distanceM) : dfCm.format(distanceCm);
        CanonMakerNotes.addTag(exifTags, CanonMakerNotes.tagId(4, 19), "SubjectDistance", d);
    }

    private CanonMakerNoteTag4Formatter() {
    }
}

