/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.formatter.canon;

import java.text.DecimalFormat;
import org.jphototagger.exif.ExifTag;
import org.jphototagger.exif.ExifTags;
import org.jphototagger.exif.formatter.canon.CanonMakerNotes;

final class CanonMakerNoteTag1Formatter {
    private static final int CANON_TAG = 1;

    static void add(short[] values, ExifTags exifTags) {
        CanonMakerNoteTag1Formatter.addFocusMode(values, exifTags);
        CanonMakerNoteTag1Formatter.addLens(values, exifTags);
    }

    private static void addLens(short[] values, ExifTags exifTags) {
        int maxValueIndex = 24;
        if (24 >= values.length) {
            return;
        }
        double mmFactor = values[24];
        assert (mmFactor > 0.0);
        if (mmFactor <= 0.0) {
            return;
        }
        double minF = (double)values[23] / mmFactor;
        double maxF = (double)values[22] / mmFactor;
        boolean fixFocalLength = Math.abs(minF - maxF) < 1.0E-7;
        DecimalFormat df = new DecimalFormat("#.#");
        String lens = fixFocalLength ? df.format(minF) + " mm" : df.format(minF) + "-" + df.format(maxF) + " mm";
        CanonMakerNotes.addTag(exifTags, ExifTag.Properties.MAKER_NOTE_LENS.getTagId(), "Lens", lens);
    }

    private static void addFocusMode(short[] values, ExifTags exifTags) {
        int offset = 8;
        int valueIndex = 7;
        if (7 >= values.length) {
            return;
        }
        short value = values[7];
        String mode = null;
        switch (value) {
            case 0: {
                mode = "One-Shot";
                break;
            }
            case 1: {
                mode = "AI Servo";
                break;
            }
            case 2: {
                mode = "AI Focus";
                break;
            }
            case 3: {
                mode = "MF";
                break;
            }
            case 4: {
                mode = "Single AF";
                break;
            }
            case 5: {
                mode = "Continuous AF";
                break;
            }
            case 6: {
                mode = "MF";
                break;
            }
            default: {
                return;
            }
        }
        CanonMakerNotes.addTag(exifTags, CanonMakerNotes.tagId(1, 8), "FocusMode", mode);
    }

    private CanonMakerNoteTag1Formatter() {
    }
}

