/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.formatter.canon;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.exif.datatype.ExifValueUtil;
import org.jphototagger.exif.formatter.canon.CanonIfd;
import org.jphototagger.image.ImageFileType;
import org.jphototagger.lib.thirdparty.KMPMatch;
import org.jphototagger.lib.util.ByteUtil;

public final class CanonMakerNote {
    private static final byte[] JPEG_MAGIC_BYTES = new byte[]{-1, -40};
    private static final byte[] JPEG_EXIF_MAGIC_BYTES = new byte[]{69, 120, 105, 102, 0, 0};
    private static final byte[] JPEG_TIFF_MAGIC_BYTES = new byte[]{73, 73, 42, 0, 8, 0, 0, 0};
    private static final byte[] JPEG_APP1_MARKER = new byte[]{-1, -31};
    private static final byte[] JPEG_SOS_MARKER = new byte[]{-1, -38};
    private static final ByteOrder JPEG_BYTE_ORDER = ByteOrder.BIG_ENDIAN;

    static byte[] getRawValueOfTag(File file, int tag, CanonIfd ifd) {
        CanonIfd.Entry entry = ifd.getEntryOfTag(tag);
        if (entry == null) {
            return null;
        }
        if (ImageFileType.isJpegFile((String)file.getName())) {
            return CanonMakerNote.rawValueFromJpeg(file, entry);
        }
        return CanonMakerNote.rawValueFromTiff(file, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] rawValueFromJpeg(File file, CanonIfd.Entry entry) {
        byte[] byArray;
        int tiffStart;
        long app1DataPos;
        RandomAccessFile raf;
        block15: {
            byte[] app1Data;
            block14: {
                block13: {
                    short app1DataSize;
                    block12: {
                        block11: {
                            block10: {
                                raf = null;
                                raf = new RandomAccessFile(file, "r");
                                if (CanonMakerNote.isJpegFile(raf)) break block10;
                                byte[] byArray2 = null;
                                CanonMakerNote.close(raf);
                                return byArray2;
                            }
                            if (CanonMakerNote.seekToJpegApp1Marker(raf)) break block11;
                            byte[] byArray3 = null;
                            CanonMakerNote.close(raf);
                            return byArray3;
                        }
                        app1DataSize = CanonMakerNote.getJpegMarkerDataSize(raf);
                        if (app1DataSize - 2 > 0) break block12;
                        byte[] byArray4 = null;
                        CanonMakerNote.close(raf);
                        return byArray4;
                    }
                    app1Data = new byte[app1DataSize - 2];
                    app1DataPos = raf.getFilePointer();
                    raf.seek(app1DataPos + 2L);
                    int read = raf.read(app1Data, 0, app1DataSize - 2);
                    if (read == app1DataSize - 2) break block13;
                    byte[] byArray5 = null;
                    CanonMakerNote.close(raf);
                    return byArray5;
                }
                if (CanonMakerNote.hasExif(app1Data)) break block14;
                byte[] byArray6 = null;
                CanonMakerNote.close(raf);
                return byArray6;
            }
            tiffStart = KMPMatch.indexOf((byte[])app1Data, (byte[])JPEG_TIFF_MAGIC_BYTES);
            if (tiffStart > 0) break block15;
            byte[] byArray7 = null;
            CanonMakerNote.close(raf);
            return byArray7;
        }
        try {
            long valueOffset = app1DataPos + 2L + (long)tiffStart + (long)entry.getValueOffset();
            int valueByteCount = entry.getValueByteCount();
            byArray = CanonMakerNote.rawValue(file, valueOffset, valueByteCount);
        }
        catch (Throwable t) {
            try {
                Logger.getLogger(CanonMakerNote.class.getName()).log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                CanonMakerNote.close(raf);
                throw throwable;
            }
            CanonMakerNote.close(raf);
            return null;
        }
        CanonMakerNote.close(raf);
        return byArray;
    }

    private static boolean hasExif(byte[] raw) {
        return KMPMatch.indexOf((byte[])raw, (byte[])JPEG_EXIF_MAGIC_BYTES) >= 0;
    }

    private static boolean seekToJpegApp1Marker(RandomAccessFile raf) throws Exception {
        boolean found = false;
        long markerOffset = 2L;
        byte[] marker = new byte[2];
        do {
            boolean isSos;
            if (!CanonMakerNote.isSeekOk(raf, markerOffset)) {
                return false;
            }
            raf.seek(markerOffset);
            if (!CanonMakerNote.isReadLengthOk(raf, 2L)) {
                return false;
            }
            int read = raf.read(marker, 0, 2);
            if (read != 2) {
                return false;
            }
            found = ByteUtil.compareTo((byte[])marker, (byte[])JPEG_APP1_MARKER) == 0;
            boolean bl = isSos = ByteUtil.compareTo((byte[])marker, (byte[])JPEG_SOS_MARKER) == 0;
            if (isSos) {
                return false;
            }
            if (found) continue;
            markerOffset = raf.getFilePointer() + (long)CanonMakerNote.getJpegMarkerDataSize(raf);
        } while (!found);
        return found;
    }

    private static boolean isSeekOk(RandomAccessFile raf, long offset) throws Exception {
        boolean ok;
        long pos = raf.getFilePointer();
        long fileLength = raf.length();
        boolean bl = ok = offset >= 0L && pos + offset < fileLength;
        assert (ok) : "Invalid seek! Current pos: " + pos + ", will seek to offset: " + offset + ", file length: " + fileLength;
        return ok;
    }

    private static boolean isReadLengthOk(RandomAccessFile raf, long length) throws Exception {
        boolean ok;
        long pos = raf.getFilePointer();
        long fileLength = raf.length();
        boolean bl = ok = length > 0L && pos + length < fileLength;
        assert (ok) : "Invalid read! Current pos: " + pos + ", will read: " + length + " bytes, file length: " + fileLength;
        return ok;
    }

    private static short getJpegMarkerDataSize(RandomAccessFile raf) throws Exception {
        if (!CanonMakerNote.isReadLengthOk(raf, 2L)) {
            return -1;
        }
        byte[] size = new byte[2];
        long pos = raf.getFilePointer();
        int read = raf.read(size, 0, 2);
        if (read != 2) {
            throw new IOException("Size read != 2");
        }
        raf.seek(pos);
        return ExifValueUtil.convertRawValueToShort(size, JPEG_BYTE_ORDER);
    }

    private static boolean isJpegFile(RandomAccessFile raf) throws Exception {
        byte[] start = new byte[2];
        raf.seek(0L);
        int read = raf.read(start, 0, 2);
        if (read != 2) {
            return false;
        }
        return ByteUtil.compareTo((byte[])start, (byte[])JPEG_MAGIC_BYTES) == 0;
    }

    private static byte[] rawValueFromTiff(File file, CanonIfd.Entry entry) {
        int valueOffset = entry.getValueOffset();
        int valueByteCount = entry.getValueByteCount();
        return CanonMakerNote.rawValue(file, valueOffset, valueByteCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] rawValue(File file, long valueOffset, int valueByteCount) {
        byte[] byArray;
        long minFileLength = valueOffset + (long)valueByteCount + 1L;
        long fileLength = file.length();
        assert (fileLength >= minFileLength);
        if (fileLength < minFileLength) {
            return null;
        }
        RandomAccessFile raf = null;
        try {
            byte[] rawValue = new byte[valueByteCount];
            raf = new RandomAccessFile(file, "r");
            raf.seek(valueOffset);
            raf.read(rawValue, 0, valueByteCount);
            byArray = rawValue;
        }
        catch (Throwable t) {
            try {
                Logger.getLogger(CanonMakerNote.class.getName()).log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                CanonMakerNote.close(raf);
                throw throwable;
            }
            CanonMakerNote.close(raf);
            return null;
        }
        CanonMakerNote.close(raf);
        return byArray;
    }

    private static void close(RandomAccessFile raf) {
        if (raf != null) {
            try {
                raf.close();
            }
            catch (Throwable t) {
                Logger.getLogger(CanonMakerNote.class.getName()).log(Level.SEVERE, null, t);
            }
        }
    }

    static short[] getTag1Values(File file, CanonIfd ifd) {
        byte[] raw = CanonMakerNote.getRawValueOfTag(file, 1, ifd);
        if (raw == null) {
            return null;
        }
        return CanonMakerNote.shortValues(raw, ifd.getByteOrder());
    }

    static short[] getTag4Values(File file, CanonIfd ifd) {
        byte[] raw = CanonMakerNote.getRawValueOfTag(file, 4, ifd);
        if (raw == null) {
            return null;
        }
        return CanonMakerNote.shortValues(raw, ifd.getByteOrder());
    }

    private static short[] shortValues(byte[] raw, ByteOrder byteOrder) {
        assert (raw.length >= 2);
        if (raw.length < 2) {
            return null;
        }
        byte[] rawValueLen = new byte[2];
        System.arraycopy(raw, 0, rawValueLen, 0, 2);
        int valueCount = ExifValueUtil.convertRawValueToShort(rawValueLen, byteOrder) / 2 - 1;
        if (valueCount <= 0) {
            return null;
        }
        int minLength = 2 + valueCount * 2;
        if (raw.length < minLength) {
            return null;
        }
        short[] values = new short[valueCount];
        byte[] rawValue = new byte[2];
        for (int i = 0; i < valueCount; ++i) {
            System.arraycopy(raw, 2 + 2 * i, rawValue, 0, 2);
            values[i] = ExifValueUtil.convertRawValueToShort(rawValue, byteOrder);
        }
        return values;
    }

    private CanonMakerNote() {
    }
}

