/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.formatter.canon;

import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.jphototagger.exif.datatype.ExifValueType;
import org.jphototagger.exif.datatype.ExifValueUtil;

public final class CanonIfd {
    private final byte[] rawValue;
    private final ByteOrder byteOrder;
    private final int entryCount;
    private final Entry[] entries;
    private final Map<Integer, Entry> entryOfTag = new HashMap<Integer, Entry>();

    public CanonIfd(byte[] rawValue, ByteOrder byteOrder) {
        if (rawValue == null) {
            throw new NullPointerException("rawValue == null");
        }
        if (byteOrder == null) {
            throw new NullPointerException("byteOrder == null");
        }
        this.rawValue = CanonIfd.copy(rawValue);
        this.byteOrder = byteOrder;
        this.entryCount = this.entryCountFromRaw();
        Entry[] entryArray = this.entries = this.entryCount > 0 ? new Entry[this.entryCount] : null;
        if (this.canSetEntries()) {
            this.setEntries();
        }
    }

    private boolean canSetEntries() {
        int requiredByteCount = 2 + this.entryCount * 12;
        return this.entryCount > 0 && this.rawValue.length >= requiredByteCount;
    }

    private static byte[] copy(byte[] bytes) {
        byte[] copy = new byte[bytes.length];
        System.arraycopy(bytes, 0, copy, 0, bytes.length);
        return copy;
    }

    private int entryCountFromRaw() {
        if (this.rawValue.length < 2) {
            return 0;
        }
        byte[] raw = new byte[2];
        System.arraycopy(this.rawValue, 0, raw, 0, 2);
        return ExifValueUtil.convertRawValueToShort(raw, this.byteOrder);
    }

    private void setEntries() {
        if (this.entryCount <= 0) {
            return;
        }
        if (!this.canSetEntries()) {
            assert (false);
            return;
        }
        int entryIndex = 0;
        for (int i = 0; i < this.entryCount; ++i) {
            byte[] r = new byte[12];
            System.arraycopy(this.rawValue, 2 + i * 12, r, 0, 12);
            Entry entry = this.createEntry(r);
            this.entries[entryIndex++] = entry;
            this.entryOfTag.put(entry.getTag(), entry);
        }
    }

    private boolean canCreateEntry(byte[] raw) {
        return raw.length == 12;
    }

    private Entry createEntry(byte[] raw) {
        if (!this.canCreateEntry(raw)) {
            assert (false);
            return null;
        }
        byte[] tagBytes = new byte[2];
        byte[] fieldTypeBytes = new byte[2];
        byte[] valueNumberBytes = new byte[4];
        byte[] valueOffsetBytes = new byte[4];
        System.arraycopy(raw, 0, tagBytes, 0, 2);
        System.arraycopy(raw, 2, fieldTypeBytes, 0, 2);
        System.arraycopy(raw, 4, valueNumberBytes, 0, 4);
        System.arraycopy(raw, 8, valueOffsetBytes, 0, 4);
        short tag = ExifValueUtil.convertRawValueToShort(tagBytes, this.byteOrder);
        short fieldType = ExifValueUtil.convertRawValueToShort(fieldTypeBytes, this.byteOrder);
        ExifValueType dataType = ExifValueType.parseInt(fieldType);
        int valueNumber = ExifValueUtil.convertRawValueToInt(valueNumberBytes, this.byteOrder);
        int offsetBytes = dataType.getBitCount() * valueNumber > 32 ? ExifValueUtil.convertRawValueToInt(valueOffsetBytes, this.byteOrder) : -1;
        return new Entry(tag, fieldType, valueNumber, offsetBytes, raw);
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public Entry getEntryOfTag(int tag) {
        return this.entryOfTag.get(tag);
    }

    public byte[] getTagAsRawValue(int tag) {
        int byteCount;
        Entry entry = this.entryOfTag.get(tag);
        if (entry == null) {
            return null;
        }
        int byteOffset = entry.getValueOffset();
        if (this.rawValue.length < byteOffset + (byteCount = entry.getValueNumber() * entry.dataType().getBitCount() / 8)) {
            return null;
        }
        byte[] raw = new byte[byteCount];
        System.arraycopy(this.rawValue, byteOffset, raw, 0, byteCount);
        return raw;
    }

    public static class Entry {
        private final int tag;
        private final int fieldType;
        private final int valueNumber;
        private final int valueOffset;
        private final byte[] raw;

        public Entry(int tag, int fieldType, int valueNumber, int valueOffset, byte[] raw) {
            this.tag = tag;
            this.fieldType = fieldType;
            this.valueNumber = valueNumber;
            this.valueOffset = valueOffset;
            this.raw = CanonIfd.copy(raw);
        }

        public int getFieldType() {
            return this.fieldType;
        }

        public ExifValueType dataType() {
            return ExifValueType.parseInt(this.fieldType);
        }

        public byte[] getRaw() {
            byte[] r = new byte[12];
            System.arraycopy(this.raw, 0, r, 0, 12);
            return r;
        }

        public int getValueByteCount() {
            return this.dataType().getBitCount() / 8 * this.valueNumber;
        }

        public int getTag() {
            return this.tag;
        }

        public int getValueNumber() {
            return this.valueNumber;
        }

        public int getValueOffset() {
            return this.valueOffset;
        }
    }
}

