/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.formatter;

import java.util.HashMap;
import java.util.Map;
import org.jphototagger.exif.Ensure;
import org.jphototagger.exif.ExifIfd;
import org.jphototagger.exif.ExifTag;
import org.jphototagger.exif.datatype.ExifShort;
import org.jphototagger.exif.formatter.ExifFormatter;

public final class ExifFormatterWhiteBalance
extends ExifFormatter {
    public static final ExifFormatterWhiteBalance INSTANCE = new ExifFormatterWhiteBalance();
    private static final Map<Integer, String> EXIF_KEY_OF_WHITE_BALANCE = new HashMap<Integer, String>();

    private ExifFormatterWhiteBalance() {
    }

    @Override
    public String format(ExifTag exifTag) {
        ExifShort es;
        short value;
        if (exifTag == null) {
            throw new NullPointerException("exifTag == null");
        }
        Ensure.exifTagId(exifTag, ExifTag.Properties.WHITE_BALANCE);
        if (ExifShort.isRawValueByteCountOk(exifTag.getRawValue()) && EXIF_KEY_OF_WHITE_BALANCE.containsKey(value = (es = new ExifShort(exifTag.getRawValue(), exifTag.convertByteOrderIdToByteOrder())).getValue())) {
            return this.translate(ExifIfd.EXIF, EXIF_KEY_OF_WHITE_BALANCE.get(value));
        }
        return "?";
    }

    static {
        EXIF_KEY_OF_WHITE_BALANCE.put(0, "WhiteBalanceAutomatic");
        EXIF_KEY_OF_WHITE_BALANCE.put(1, "WhiteBalanceManual");
    }
}

