/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.formatter;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.jphototagger.exif.Ensure;
import org.jphototagger.exif.ExifTag;
import org.jphototagger.exif.formatter.ExifFormatter;

public final class ExifFormatterUserComment
extends ExifFormatter {
    public static final ExifFormatterUserComment INSTANCE = new ExifFormatterUserComment();
    private static final byte[] CODE_ASCII = new byte[]{65, 83, 67, 73, 73, 0, 0, 0};
    private static final byte[] CODE_JIS = new byte[]{74, 73, 83, 0, 0, 0, 0, 0};
    private static final byte[] CODE_UNICODE = new byte[]{85, 78, 73, 67, 79, 68, 69, 0};
    private static final byte[] CODE_UNDEFINED = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};

    private ExifFormatterUserComment() {
    }

    @Override
    public String format(ExifTag exifTag) {
        if (exifTag == null) {
            throw new NullPointerException("exifTag == null");
        }
        Ensure.exifTagId(exifTag, ExifTag.Properties.USER_COMMENT);
        byte[] rawValue = exifTag.getRawValue();
        if (rawValue.length <= 8) {
            return "";
        }
        CharCode charCode = ExifFormatterUserComment.getEncoding(rawValue);
        if (!charCode.hasCharset()) {
            return "";
        }
        byte[] raw = Arrays.copyOfRange(rawValue, 8, rawValue.length);
        return new String(raw, charCode.charset());
    }

    private static CharCode getEncoding(byte[] rawValue) {
        assert (rawValue.length >= 8) : rawValue.length;
        byte[] code = Arrays.copyOf(rawValue, 8);
        if (Arrays.equals(code, CODE_ASCII)) {
            return CharCode.ASCII;
        }
        if (Arrays.equals(code, CODE_JIS)) {
            return CharCode.JIS;
        }
        if (Arrays.equals(code, CODE_UNICODE)) {
            return CharCode.UNICODE;
        }
        if (Arrays.equals(code, CODE_UNDEFINED)) {
            return CharCode.UNDEFINED;
        }
        return CharCode.UNREGOGNIZED;
    }

    private static enum CharCode {
        ASCII("US-ASCII"),
        JIS("JISAutoDetect"),
        UNICODE("UTF-8"),
        UNDEFINED(""),
        UNREGOGNIZED("");

        private final String charsetName;

        private CharCode(String name) {
            this.charsetName = name;
        }

        public boolean hasCharset() {
            return !this.charsetName.isEmpty();
        }

        public Charset charset() {
            if (this.charsetName.isEmpty()) {
                throw new IllegalStateException();
            }
            return Charset.forName(this.charsetName);
        }
    }
}

