/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.formatter;

import java.util.HashMap;
import java.util.Map;
import org.jphototagger.exif.Ensure;
import org.jphototagger.exif.ExifIfd;
import org.jphototagger.exif.ExifTag;
import org.jphototagger.exif.datatype.ExifShort;
import org.jphototagger.exif.formatter.ExifFormatter;

public final class ExifFormatterSharpness
extends ExifFormatter {
    public static final ExifFormatterSharpness INSTANCE = new ExifFormatterSharpness();
    private static final Map<Integer, String> EXIF_KEY_OF_SHARPNESS = new HashMap<Integer, String>();

    private ExifFormatterSharpness() {
    }

    @Override
    public String format(ExifTag exifTag) {
        ExifShort es;
        short value;
        if (exifTag == null) {
            throw new NullPointerException("exifTag == null");
        }
        Ensure.exifTagId(exifTag, ExifTag.Properties.SHARPNESS);
        if (ExifShort.getRawValueByteCount() == exifTag.getRawValue().length && EXIF_KEY_OF_SHARPNESS.containsKey(value = (es = new ExifShort(exifTag.getRawValue(), exifTag.convertByteOrderIdToByteOrder())).getValue())) {
            return this.translate(ExifIfd.EXIF, EXIF_KEY_OF_SHARPNESS.get(value));
        }
        return "?";
    }

    static {
        EXIF_KEY_OF_SHARPNESS.put(0, "SharpnessNormal");
        EXIF_KEY_OF_SHARPNESS.put(1, "SharpnessSoft");
        EXIF_KEY_OF_SHARPNESS.put(2, "SharpnessHard");
    }
}

