/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.formatter;

import java.util.HashMap;
import java.util.Map;
import org.jphototagger.exif.Ensure;
import org.jphototagger.exif.ExifIfd;
import org.jphototagger.exif.ExifTag;
import org.jphototagger.exif.datatype.ExifShort;
import org.jphototagger.exif.formatter.ExifFormatter;

public final class ExifFormatterSaturation
extends ExifFormatter {
    public static final ExifFormatterSaturation INSTANCE = new ExifFormatterSaturation();
    private static final Map<Integer, String> exifKeyOfSaturation = new HashMap<Integer, String>();

    private ExifFormatterSaturation() {
    }

    @Override
    public String format(ExifTag exifTag) {
        ExifShort es;
        short value;
        if (exifTag == null) {
            throw new NullPointerException("exifTag == null");
        }
        Ensure.exifTagId(exifTag, ExifTag.Properties.SATURATION);
        if (ExifShort.isRawValueByteCountOk(exifTag.getRawValue()) && exifKeyOfSaturation.containsKey(value = (es = new ExifShort(exifTag.getRawValue(), exifTag.convertByteOrderIdToByteOrder())).getValue())) {
            return this.translate(ExifIfd.EXIF, exifKeyOfSaturation.get(value));
        }
        return "?";
    }

    static {
        exifKeyOfSaturation.put(0, "SaturationNormal");
        exifKeyOfSaturation.put(1, "SaturationLow");
        exifKeyOfSaturation.put(2, "SaturationHigh");
    }
}

