/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.formatter;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.exif.Ensure;
import org.jphototagger.exif.ExifTag;
import org.jphototagger.exif.formatter.ExifFormatter;

public final class ExifFormatterGpsDateStamp
extends ExifFormatter {
    public static final ExifFormatterGpsDateStamp INSTANCE = new ExifFormatterGpsDateStamp();

    private ExifFormatterGpsDateStamp() {
    }

    @Override
    public String format(ExifTag exifTag) {
        if (exifTag == null) {
            throw new NullPointerException("exifTag == null");
        }
        Ensure.exifTagId(exifTag, ExifTag.Properties.GPS_DATE_STAMP);
        byte[] rawValue = exifTag.getRawValue();
        String rawString = new String(rawValue);
        if (rawString.length() != 11) {
            return rawString;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy:MM:dd");
            Date date = df.parse(rawString.substring(0, 10));
            return DateFormat.getDateInstance(0).format(date);
        }
        catch (Throwable t) {
            Logger.getLogger(ExifFormatterGpsDateStamp.class.getName()).log(Level.SEVERE, null, t);
            return rawString;
        }
    }
}

