/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.formatter;

import org.jphototagger.exif.Ensure;
import org.jphototagger.exif.ExifIfd;
import org.jphototagger.exif.ExifTag;
import org.jphototagger.exif.datatype.ExifAscii;
import org.jphototagger.exif.formatter.ExifFormatter;
import org.jphototagger.lib.util.ByteUtil;

public final class ExifFormatterFlash
extends ExifFormatter {
    public static final ExifFormatterFlash INSTANCE = new ExifFormatterFlash();

    private ExifFormatterFlash() {
    }

    @Override
    public String format(ExifTag exifTag) {
        if (exifTag == null) {
            throw new NullPointerException("exifTag == null");
        }
        Ensure.exifTagId(exifTag, ExifTag.Properties.FLASH);
        byte[] rawValue = exifTag.getRawValue();
        if (rawValue != null && rawValue.length >= 1) {
            boolean hasFlash;
            boolean[] bitsByte1 = ByteUtil.getBits((byte)rawValue[0]);
            boolean fired = bitsByte1[0];
            boolean bl = hasFlash = !bitsByte1[5];
            if (!hasFlash) {
                return this.translate(ExifIfd.EXIF, "FlashNone");
            }
            return fired ? this.translate(ExifIfd.EXIF, "FlashFired") : this.translate(ExifIfd.EXIF, "FlashNotFired");
        }
        return ExifAscii.convertRawValueToString(rawValue);
    }
}

