/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.formatter;

import org.jphototagger.exif.Ensure;
import org.jphototagger.exif.ExifTag;
import org.jphototagger.exif.datatype.ExifRational;
import org.jphototagger.exif.datatype.Fraction;
import org.jphototagger.exif.formatter.ExifFormatter;

public final class ExifFormatterExposureTime
extends ExifFormatter {
    public static final ExifFormatterExposureTime INSTANCE = new ExifFormatterExposureTime();

    private ExifFormatterExposureTime() {
    }

    @Override
    public String format(ExifTag exifTag) {
        if (exifTag == null) {
            throw new NullPointerException("exifTag == null");
        }
        Ensure.exifTagId(exifTag, ExifTag.Properties.EXPOSURE_TIME);
        if (ExifRational.getRawValueByteCount() == exifTag.getRawValue().length) {
            ExifRational time = new ExifRational(exifTag.getRawValue(), exifTag.convertByteOrderIdToByteOrder());
            Fraction fraction = ExifFormatterExposureTime.getAsExposureTime(time);
            int numerator = fraction.getNumerator();
            int denominator = fraction.getDenominator();
            if (denominator > 1) {
                return Integer.toString(numerator) + " / " + Integer.toString(denominator) + " s";
            }
            if (numerator > 1) {
                return Integer.toString(numerator) + " s";
            }
            if (numerator / denominator == 1) {
                return "1 s";
            }
        }
        return "?";
    }

    private static Fraction getAsExposureTime(ExifRational er) {
        int denominator;
        int numerator = er.getNumerator();
        double result = (double)numerator / (double)(denominator = er.getDenominator());
        if (result < 1.0) {
            return new Fraction(1, (int)((double)denominator / (double)numerator + 0.5));
        }
        if (result >= 1.0) {
            return new Fraction((int)((double)numerator / (double)denominator + 0.5), 1);
        }
        return new Fraction(0, 0);
    }
}

