/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.formatter;

import java.util.HashMap;
import java.util.Map;
import org.jphototagger.exif.Ensure;
import org.jphototagger.exif.ExifIfd;
import org.jphototagger.exif.ExifTag;
import org.jphototagger.exif.datatype.ExifShort;
import org.jphototagger.exif.formatter.ExifFormatter;

public final class ExifFormatterExposureProgram
extends ExifFormatter {
    public static final ExifFormatterExposureProgram INSTANCE = new ExifFormatterExposureProgram();
    private static final Map<Integer, String> EXIF_KEY_OF_EXPOSURE_PROGRAM = new HashMap<Integer, String>();

    private ExifFormatterExposureProgram() {
    }

    @Override
    public String format(ExifTag exifTag) {
        ExifShort es;
        short value;
        if (exifTag == null) {
            throw new NullPointerException("exifTag == null");
        }
        Ensure.exifTagId(exifTag, ExifTag.Properties.EXPOSURE_PROGRAM);
        if (ExifShort.isRawValueByteCountOk(exifTag.getRawValue()) && EXIF_KEY_OF_EXPOSURE_PROGRAM.containsKey(value = (es = new ExifShort(exifTag.getRawValue(), exifTag.convertByteOrderIdToByteOrder())).getValue())) {
            return this.translate(ExifIfd.EXIF, EXIF_KEY_OF_EXPOSURE_PROGRAM.get(value));
        }
        return "?";
    }

    static {
        EXIF_KEY_OF_EXPOSURE_PROGRAM.put(0, "ExposureProgramUnkonwn");
        EXIF_KEY_OF_EXPOSURE_PROGRAM.put(1, "ExposureProgramManual");
        EXIF_KEY_OF_EXPOSURE_PROGRAM.put(2, "ExposureProgramNormalProgram");
        EXIF_KEY_OF_EXPOSURE_PROGRAM.put(3, "ExposureProgramAperturePriority");
        EXIF_KEY_OF_EXPOSURE_PROGRAM.put(4, "ExposureProgramTimePriority");
        EXIF_KEY_OF_EXPOSURE_PROGRAM.put(5, "ExposureProgramCreativ");
        EXIF_KEY_OF_EXPOSURE_PROGRAM.put(6, "ExposureProgramAction");
        EXIF_KEY_OF_EXPOSURE_PROGRAM.put(7, "ExposureProgramPortrait");
        EXIF_KEY_OF_EXPOSURE_PROGRAM.put(8, "ExposureProgramLandscape");
    }
}

