/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.formatter;

import java.util.HashMap;
import java.util.Map;
import org.jphototagger.exif.Ensure;
import org.jphototagger.exif.ExifIfd;
import org.jphototagger.exif.ExifTag;
import org.jphototagger.exif.datatype.ExifShort;
import org.jphototagger.exif.formatter.ExifFormatter;

public final class ExifFormatterContrast
extends ExifFormatter {
    public static final ExifFormatterContrast INSTANCE = new ExifFormatterContrast();
    private static final Map<Integer, String> EXIF_KEY_OF_CONTRAST = new HashMap<Integer, String>();

    @Override
    public String format(ExifTag exifTag) {
        ExifShort es;
        short value;
        if (exifTag == null) {
            throw new NullPointerException("exifTag == null");
        }
        Ensure.exifTagId(exifTag, ExifTag.Properties.CONTRAST);
        if (ExifShort.isRawValueByteCountOk(exifTag.getRawValue()) && EXIF_KEY_OF_CONTRAST.containsKey(value = (es = new ExifShort(exifTag.getRawValue(), exifTag.convertByteOrderIdToByteOrder())).getValue())) {
            return this.translate(ExifIfd.EXIF, EXIF_KEY_OF_CONTRAST.get(value));
        }
        return "?";
    }

    private ExifFormatterContrast() {
    }

    static {
        EXIF_KEY_OF_CONTRAST.put(0, "ContrastNormal");
        EXIF_KEY_OF_CONTRAST.put(1, "ContrastLow");
        EXIF_KEY_OF_CONTRAST.put(2, "ContrastHigh");
    }
}

