/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.datatype;

public enum ExifValueType {
    BYTE(1, 8),
    ASCII(2, 8),
    SHORT(3, 16),
    LONG(4, 32),
    RATIONAL(5, 64),
    UNDEFINED(7, 8),
    SLONG(9, 32),
    SRATIONAL(10, 64),
    SHORT_OR_LONG(-1, -1);

    private final int intValue;
    private final int bitCount;

    private ExifValueType(int intValue, int bitCount) {
        this.intValue = intValue;
        this.bitCount = bitCount;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public static ExifValueType parseInt(int anInt) {
        for (ExifValueType valueType : ExifValueType.values()) {
            if (valueType.intValue != anInt) continue;
            return valueType;
        }
        return UNDEFINED;
    }

    public static boolean isIntValue(int anInt) {
        for (ExifValueType valueType : ExifValueType.values()) {
            if (valueType.intValue != anInt) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.intValue + " (" + this.name() + ")";
    }
}

