/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.datatype;

import java.nio.ByteOrder;
import org.jphototagger.exif.Ensure;
import org.jphototagger.exif.datatype.ExifValueType;
import org.jphototagger.exif.datatype.ExifValueUtil;

public final class ExifShort {
    private final short value;

    public ExifShort(byte[] rawValue, ByteOrder byteOrder) {
        if (rawValue == null) {
            throw new NullPointerException("rawValue == null");
        }
        if (byteOrder == null) {
            throw new NullPointerException("byteOrder == null");
        }
        Ensure.length(rawValue, ExifShort.getRawValueByteCount());
        this.value = ExifValueUtil.convertRawValueToShort(rawValue, byteOrder);
        Ensure.zeroOrPositive(this.value);
    }

    public short getValue() {
        return this.value;
    }

    public static boolean isRawValueZeroOrPositive(byte[] rawValue, ByteOrder byteOrder) {
        if (rawValue == null) {
            throw new NullPointerException("rawValue == null");
        }
        if (byteOrder == null) {
            throw new NullPointerException("byteOrder == null");
        }
        return rawValue.length == ExifShort.getRawValueByteCount() && ExifValueUtil.convertRawValueToShort(rawValue, byteOrder) >= 0;
    }

    public static int getRawValueByteCount() {
        return 2;
    }

    public static boolean isRawValueByteCountOk(byte[] rawValue) {
        return rawValue == null ? false : rawValue.length == ExifShort.getRawValueByteCount();
    }

    public static ExifValueType getValueType() {
        return ExifValueType.SHORT;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExifShort)) {
            return false;
        }
        ExifShort other = (ExifShort)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int hash = 5;
        return 295 + this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }
}

