/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.datatype;

import java.nio.ByteOrder;
import java.util.Arrays;
import org.jphototagger.exif.Ensure;
import org.jphototagger.exif.datatype.ExifValueType;
import org.jphototagger.exif.datatype.ExifValueUtil;

public final class ExifRational {
    private final int numerator;
    private final int denominator;

    public ExifRational(byte[] rawValue, ByteOrder byteOrder) {
        Ensure.length(rawValue, ExifRational.getRawValueByteCount());
        this.numerator = ExifValueUtil.convertRawValueToInt(Arrays.copyOfRange(rawValue, 0, 4), byteOrder);
        this.denominator = ExifValueUtil.convertRawValueToInt(Arrays.copyOfRange(rawValue, 4, 8), byteOrder);
        Ensure.zeroOrPositive(this.numerator, this.denominator);
        Ensure.noDivisionByZero(this.denominator);
    }

    public static boolean isValid(byte[] rawValue, ByteOrder byteOrder) {
        if (rawValue == null) {
            throw new NullPointerException("rawValue == null");
        }
        if (byteOrder == null) {
            throw new NullPointerException("byteOrder == null");
        }
        if (rawValue.length == ExifRational.getRawValueByteCount()) {
            int numerator = ExifValueUtil.convertRawValueToInt(Arrays.copyOfRange(rawValue, 0, 4), byteOrder);
            int denominator = ExifValueUtil.convertRawValueToInt(Arrays.copyOfRange(rawValue, 4, 8), byteOrder);
            boolean negative = numerator < 0 && denominator > 0 || numerator > 0 && denominator < 0;
            return !negative && denominator != 0;
        }
        return false;
    }

    public static int getRawValueByteCount() {
        return 8;
    }

    public static boolean isRawValueByteCountOk(byte[] rawValue) {
        return rawValue == null ? false : rawValue.length == ExifRational.getRawValueByteCount();
    }

    public int getDenominator() {
        return this.denominator;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public static ExifValueType getValueType() {
        return ExifValueType.RATIONAL;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExifRational)) {
            return false;
        }
        ExifRational other = (ExifRational)obj;
        return this.numerator == other.numerator && this.denominator == other.denominator;
    }

    public int hashCode() {
        int hash = 3;
        hash = 13 * hash + this.numerator;
        hash = 13 * hash + this.denominator;
        return hash;
    }

    public String toString() {
        return Integer.toString(this.denominator) + "/" + Integer.toString(this.numerator);
    }
}

