/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.datatype;

import java.nio.ByteOrder;
import org.jphototagger.exif.Ensure;
import org.jphototagger.exif.datatype.ExifValueType;
import org.jphototagger.exif.datatype.ExifValueUtil;

public final class ExifLong {
    private final int value;

    public ExifLong(byte[] rawValue, ByteOrder byteOrder) {
        if (rawValue == null) {
            throw new NullPointerException("rawValue == null");
        }
        if (byteOrder == null) {
            throw new NullPointerException("byteOrder == null");
        }
        Ensure.length(rawValue, ExifLong.getRawValueByteCount());
        this.value = ExifValueUtil.convertRawValueToInt(rawValue, byteOrder);
        Ensure.zeroOrPositive(this.value);
    }

    public static int getRawValueByteCount() {
        return 4;
    }

    public static boolean isRawValueByteCountOk(byte[] rawValue) {
        return rawValue == null ? false : rawValue.length == ExifLong.getRawValueByteCount();
    }

    public static ExifValueType getValueType() {
        return ExifValueType.LONG;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExifLong)) {
            return false;
        }
        ExifLong other = (ExifLong)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int hash = 7;
        return 497 + this.value;
    }
}

