/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.datatype;

import org.jphototagger.exif.Ensure;
import org.jphototagger.exif.datatype.ExifValueType;

public final class ExifByte {
    private final int value;

    public ExifByte(byte[] rawValue) {
        if (rawValue == null) {
            throw new NullPointerException("rawValue == null");
        }
        Ensure.length(rawValue, ExifByte.getRawValueByteCount());
        this.value = rawValue[0];
        Ensure.zeroOrPositive(this.value);
    }

    public static int getRawValueByteCount() {
        return 1;
    }

    public static boolean isRawValueByteCountOk(byte[] rawValue) {
        return rawValue == null ? false : rawValue.length == ExifByte.getRawValueByteCount();
    }

    public static ExifValueType getValueType() {
        return ExifValueType.BYTE;
    }

    public int getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExifByte)) {
            return false;
        }
        ExifByte other = (ExifByte)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + this.value;
        return hash;
    }

    public String toString() {
        return Integer.toString(this.value);
    }
}

