/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.datatype;

import java.nio.charset.Charset;
import org.jphototagger.exif.datatype.ExifValueType;
import org.jphototagger.lib.util.ByteUtil;

public final class ExifAscii {
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private final String value;

    public ExifAscii(byte[] rawValue) {
        if (rawValue == null) {
            throw new NullPointerException("rawValue == null");
        }
        this.value = ExifAscii.convertRawValueToString(rawValue);
    }

    public static String convertRawValueToString(byte[] rawValue) {
        if (rawValue == null) {
            throw new NullPointerException("rawValue == null");
        }
        if (rawValue.length == 0) {
            return "";
        }
        if (!ExifAscii.isNullTerminated(rawValue)) {
            return "?";
        }
        if (rawValue.length == 1) {
            return "";
        }
        byte[] notNullTerminatedRawValue = new byte[rawValue.length - 1];
        System.arraycopy(rawValue, 0, notNullTerminatedRawValue, 0, notNullTerminatedRawValue.length);
        if (!ExifAscii.onlyCharacters(notNullTerminatedRawValue)) {
            return "?";
        }
        String converted = new String(notNullTerminatedRawValue, CHARSET);
        return converted;
    }

    private static boolean onlyCharacters(byte[] bytes) {
        for (int index = 0; index < bytes.length - 1; ++index) {
            boolean isCharacter;
            int intValue = ByteUtil.toInt((byte)bytes[index]);
            boolean bl = isCharacter = intValue > 0 && intValue < 256;
            if (isCharacter) continue;
            return false;
        }
        return true;
    }

    private static boolean isNullTerminated(byte[] rawValue) {
        if (rawValue.length < 1) {
            return false;
        }
        byte lastByte = rawValue[rawValue.length - 1];
        return ByteUtil.toInt((byte)lastByte) == 0;
    }

    public static ExifValueType getValueType() {
        return ExifValueType.ASCII;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExifAscii)) {
            return false;
        }
        ExifAscii other = (ExifAscii)obj;
        return this.value == null ? other.value == null : this.value.equals(other.value);
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + this.value != null ? this.value.hashCode() : 0;
        return hash;
    }

    public String toString() {
        return this.value;
    }
}

