/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif.cache;

import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.storage.CacheDirectoryProvider;
import org.jphototagger.domain.metadata.exif.event.ExifCacheClearedEvent;
import org.jphototagger.domain.metadata.exif.event.ExifCacheFileDeletedEvent;
import org.jphototagger.domain.repository.event.imagefiles.ImageFileDeletedEvent;
import org.jphototagger.domain.repository.event.imagefiles.ImageFileMovedEvent;
import org.jphototagger.exif.ExifTags;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.xml.bind.XmlObjectExporter;
import org.jphototagger.lib.xml.bind.XmlObjectImporter;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.openide.util.Lookup;

public final class ExifCache {
    public static final ExifCache INSTANCE = new ExifCache();
    private static final Logger LOGGER = Logger.getLogger(ExifCache.class.getName());
    private final File cacheDbFile = new File(this.lookupCacheDirectory().getAbsolutePath() + File.separator + "ExifCacheDb");
    private final DB cacheDb;
    private final Map<String, String> exifTags;

    public synchronized void cacheExifTags(File imageFile, ExifTags exifTags) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        if (exifTags == null) {
            throw new NullPointerException("exifTags == null");
        }
        LOGGER.log(Level.FINEST, "Caching EXIF metadata of image file ''{0}''", imageFile);
        exifTags.setLastModified(imageFile.lastModified());
        try {
            String exifTagsXml = XmlObjectExporter.marshal((Object)exifTags);
            this.exifTags.put(imageFile.getAbsolutePath(), exifTagsXml);
            this.cacheDb.commit();
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
        }
    }

    public synchronized boolean containsUpToDateExifTags(File imageFile) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        if (!this.isCached(imageFile)) {
            return false;
        }
        try {
            String exifTagsXml = this.exifTags.get(imageFile.getAbsolutePath());
            ExifTags tags = (ExifTags)XmlObjectImporter.unmarshal((String)exifTagsXml, ExifTags.class);
            return tags.getLastModified() == imageFile.lastModified();
        }
        catch (Throwable t) {
            Logger.getLogger(ExifCache.class.getName()).log(Level.SEVERE, null, t);
            return false;
        }
    }

    private synchronized boolean isCached(File imageFile) {
        return this.exifTags.containsKey(imageFile.getAbsolutePath());
    }

    public synchronized ExifTags getCachedExifTags(File imageFile) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        try {
            LOGGER.log(Level.FINEST, "Reading cached EXIF metadata of image file ''{0}''", imageFile);
            String exifTagsXml = this.exifTags.get(imageFile.getAbsolutePath());
            return (ExifTags)XmlObjectImporter.unmarshal((String)exifTagsXml, ExifTags.class);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCachedExifTags(File imageFile) {
        try {
            ExifCache exifCache = this;
            synchronized (exifCache) {
                if (this.exifTags.remove(imageFile.getAbsolutePath()) != null) {
                    this.cacheDb.commit();
                    LOGGER.log(Level.FINEST, "Deleted cache EXIF metadata of image file ''{0}''", imageFile);
                }
            }
            EventBus.publish((Object)new ExifCacheFileDeletedEvent((Object)this, imageFile));
        }
        catch (Throwable t) {
            Logger.getLogger(ExifCache.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    private synchronized void renameCachedExifTags(File oldImageFile, File newImageFile) {
        if (this.isCached(oldImageFile)) {
            try {
                String exifTagsXml = this.exifTags.get(oldImageFile.getAbsolutePath());
                this.exifTags.remove(oldImageFile.getAbsolutePath());
                this.exifTags.put(newImageFile.getAbsolutePath(), exifTagsXml);
                this.cacheDb.commit();
                LOGGER.log(Level.FINEST, "Renamed image file of cached EXIF metadata from ''{0}'' to ''{1}''", new Object[]{oldImageFile, newImageFile});
            }
            catch (Throwable t) {
                Logger.getLogger(ExifCache.class.getName()).log(Level.SEVERE, null, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int clear() {
        ExifCache exifCache = this;
        synchronized (exifCache) {
            if (this.exifTags.isEmpty()) {
                return 0;
            }
        }
        LOGGER.log(Level.INFO, "Deleting all cached EXIF metadata");
        try {
            int count;
            ExifCache exifCache2 = this;
            synchronized (exifCache2) {
                count = this.exifTags.size();
                this.exifTags.clear();
                this.cacheDb.commit();
            }
            EventBus.publish((Object)new ExifCacheClearedEvent((Object)this, count));
            return count;
        }
        catch (Throwable t) {
            Logger.getLogger(ExifCache.class.getName()).log(Level.SEVERE, null, t);
            return 0;
        }
    }

    @EventSubscriber(eventClass=ImageFileMovedEvent.class)
    public void imageFileMoved(ImageFileMovedEvent event) {
        File oldImageFile = event.getOldImageFile();
        File newImageFile = event.getNewImageFile();
        this.renameCachedExifTags(oldImageFile, newImageFile);
    }

    @EventSubscriber(eventClass=ImageFileDeletedEvent.class)
    public void imageFileRemoved(ImageFileDeletedEvent event) {
        File deletedImageFile = event.getImageFile();
        this.deleteCachedExifTags(deletedImageFile);
    }

    void init() {
        AnnotationProcessor.process((Object)this);
    }

    File getCacheDir() {
        return this.cacheDbFile.getParentFile();
    }

    private ExifCache() {
        this.ensureCacheDiretoryExists();
        this.cacheDb = DBMaker.newFileDB((File)this.cacheDbFile).closeOnJvmShutdown().make();
        this.exifTags = this.cacheDb.getHashMap("exifcache");
    }

    private File lookupCacheDirectory() {
        CacheDirectoryProvider provider = (CacheDirectoryProvider)Lookup.getDefault().lookup(CacheDirectoryProvider.class);
        return provider.getCacheDirectory("ExifCache");
    }

    private void ensureCacheDiretoryExists() {
        File cacheDir = this.cacheDbFile.getParentFile();
        if (!cacheDir.isDirectory()) {
            try {
                LOGGER.log(Level.FINEST, "Creating cache directory ''{0}''", cacheDir);
                FileUtil.ensureDirectoryExists((File)cacheDir);
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, null, t);
            }
        }
    }
}

