/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif;

import com.drew.imaging.ImageMetadataReader;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import java.io.File;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.exif.ExifIfd;
import org.jphototagger.exif.ExifTag;
import org.jphototagger.exif.ExifTags;
import org.jphototagger.exif.ExifTagsProvider;
import org.jphototagger.exif.datatype.ExifValueType;
import org.jphototagger.exif.datatype.ExifValueUtil;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.util.ByteUtil;

public final class MetaDataExtractorExifMetadataReader
implements ExifTagsProvider {
    private static final Logger LOGGER = Logger.getLogger(MetaDataExtractorExifMetadataReader.class.getName());
    private static final Set<String> SUPPORTED_FILENAME_SUFFIXES_LOWERCASE = new HashSet<String>();
    private static final Map<String, Integer> BYTE_ORDER_OF_FILENAME_SUFFIX = new HashMap<String, Integer>();

    @Override
    public boolean canReadExifTags(File file) {
        String suffix = FileUtil.getSuffix((File)file);
        String suffixLowerCase = suffix.toLowerCase();
        return SUPPORTED_FILENAME_SUFFIXES_LOWERCASE.contains(suffixLowerCase);
    }

    @Override
    public Set<String> getSupportedFilenameSuffixes() {
        return Collections.unmodifiableSet(SUPPORTED_FILENAME_SUFFIXES_LOWERCASE);
    }

    @Override
    public int addToExifTags(File fromFile, ExifTags toExifTags) throws Exception {
        int oldTagCount = toExifTags.getTagCount();
        try {
            Metadata metadata = ImageMetadataReader.readMetadata((File)fromFile);
            String suffix = FileUtil.getSuffix((File)fromFile).toLowerCase();
            for (Directory directory : metadata.getDirectories()) {
                for (Tag tag : directory.getTags()) {
                    int byteOrderValue;
                    ByteOrder byteOrder;
                    byte[] rawValue;
                    int tagId = tag.getTagType();
                    ExifTag.Properties exifProperties = ExifTag.Properties.parseInt(tagId);
                    if (exifProperties == ExifTag.Properties.UNKNOWN || (rawValue = this.getRawValue(directory, exifProperties, byteOrder = (byteOrderValue = BYTE_ORDER_OF_FILENAME_SUFFIX.get(suffix).intValue()) == 18761 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN)) == null) continue;
                    if (exifProperties.getValueType() == ExifValueType.ASCII && !MetaDataExtractorExifMetadataReader.isNullTerminated(rawValue)) {
                        rawValue = MetaDataExtractorExifMetadataReader.terminateWithNull(rawValue);
                    }
                    ExifTag exifTag = new ExifTag(tagId, exifProperties.getValueType().getIntValue(), exifProperties.getValueCount(), -1L, rawValue, tag.toString(), byteOrderValue, tag.getTagName(), ExifIfd.EXIF);
                    toExifTags.addExifTag(exifTag);
                }
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
            throw new RuntimeException("Error while reading EXIF with MetaDataExtractor for file " + fromFile);
        }
        return toExifTags.getTagCount() - oldTagCount;
    }

    private byte[] getRawValue(Directory directory, ExifTag.Properties exifProperties, ByteOrder byteOrder) {
        ExifValueType valueType = exifProperties.getValueType();
        int tagId = exifProperties.getTagId();
        Object object = directory.getObject(tagId);
        if (valueType == ExifValueType.ASCII && object instanceof String) {
            byte[] rawValue = directory.getByteArray(tagId);
            if (rawValue != null && !MetaDataExtractorExifMetadataReader.isNullTerminated(rawValue)) {
                return MetaDataExtractorExifMetadataReader.terminateWithNull(rawValue);
            }
            return null;
        }
        if (valueType == ExifValueType.SHORT && object instanceof Integer) {
            return ExifValueUtil.createRawValue(((Integer)object).longValue(), byteOrder, ExifValueType.SHORT.getBitCount() / 8);
        }
        if ((valueType == ExifValueType.LONG || valueType == ExifValueType.SHORT_OR_LONG) && object instanceof Long) {
            return ExifValueUtil.createRawValue((Long)object, byteOrder, ExifValueType.LONG.getBitCount() / 8);
        }
        if (valueType == ExifValueType.RATIONAL && object instanceof Rational) {
            Rational rational = (Rational)object;
            long numerator = rational.getNumerator();
            long denominator = rational.getDenominator();
            int longByteCount = ExifValueType.LONG.getBitCount() / 8;
            byte[] numeratorBytes = ExifValueUtil.createRawValue(numerator, byteOrder, longByteCount);
            byte[] denominatorBytes = ExifValueUtil.createRawValue(denominator, byteOrder, longByteCount);
            byte[] rawValue = new byte[longByteCount * 2];
            System.arraycopy(numeratorBytes, 0, rawValue, 0, longByteCount);
            System.arraycopy(denominatorBytes, 0, rawValue, longByteCount, longByteCount);
            return rawValue;
        }
        return null;
    }

    private static boolean isNullTerminated(byte[] rawValue) {
        if (rawValue.length < 1) {
            return false;
        }
        byte lastByte = rawValue[rawValue.length - 1];
        return ByteUtil.toInt((byte)lastByte) == 0;
    }

    private static byte[] terminateWithNull(byte[] rawValue) {
        if (rawValue == null) {
            return null;
        }
        byte[] terminatedRawValue = new byte[rawValue.length + 1];
        if (rawValue.length > 0) {
            System.arraycopy(rawValue, 0, terminatedRawValue, 0, rawValue.length);
        }
        terminatedRawValue[rawValue.length] = 0;
        return terminatedRawValue;
    }

    static {
        SUPPORTED_FILENAME_SUFFIXES_LOWERCASE.add("orf");
        BYTE_ORDER_OF_FILENAME_SUFFIX.put("orf", 18761);
        SUPPORTED_FILENAME_SUFFIXES_LOWERCASE.add("dng");
        BYTE_ORDER_OF_FILENAME_SUFFIX.put("dng", 18761);
    }
}

