/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif;

import com.imagero.reader.ImageReader;
import com.imagero.reader.MetadataUtils;
import com.imagero.reader.jpeg.JpegReader;
import com.imagero.reader.tiff.IFDEntry;
import com.imagero.reader.tiff.ImageFileDirectory;
import com.imagero.reader.tiff.TiffReader;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.exif.ExifIfd;
import org.jphototagger.exif.ExifTag;
import org.jphototagger.exif.ExifTags;
import org.jphototagger.exif.ExifTagsProvider;
import org.jphototagger.image.ImageFileType;
import org.jphototagger.lib.io.FileUtil;

public final class ImageroExifMetadataReader
implements ExifTagsProvider {
    private static final Logger LOGGER = Logger.getLogger(ImageroExifMetadataReader.class.getName());
    private static final Set<String> SUPPORTED_FILENAME_SUFFIXES_LOWERCASE = new HashSet<String>();

    @Override
    public boolean canReadExifTags(File file) {
        String suffix = FileUtil.getSuffix((File)file);
        String suffixLowerCase = suffix.toLowerCase();
        return SUPPORTED_FILENAME_SUFFIXES_LOWERCASE.contains(suffixLowerCase);
    }

    @Override
    public Set<String> getSupportedFilenameSuffixes() {
        return Collections.unmodifiableSet(SUPPORTED_FILENAME_SUFFIXES_LOWERCASE);
    }

    @Override
    public int addToExifTags(File fromFile, ExifTags toExifTags) throws Exception {
        JpegReader imageReader = null;
        int oldTagCount = toExifTags.getTagCount();
        try {
            if (ImageFileType.isJpegFile((String)fromFile.getName())) {
                LOGGER.log(Level.INFO, "Reading EXIF metadata of file ''{0}'''' with JPEG reader", fromFile);
                imageReader = new JpegReader(fromFile);
                this.addAllExifTags(imageReader, toExifTags);
            } else {
                LOGGER.log(Level.INFO, "Reading EXIF metadata of file ''{0}'''' with TIFF reader", fromFile);
                imageReader = new TiffReader(fromFile);
                TiffReader tiffReader = (TiffReader)imageReader;
                int count = tiffReader.getIFDCount();
                for (int i = 0; i < count; ++i) {
                    ImageFileDirectory iFD = tiffReader.getIFD(i);
                    this.addTagsOfIfd(iFD, ExifIfd.EXIF, toExifTags);
                }
            }
            this.closeImageReader((ImageReader)imageReader);
        }
        catch (Throwable t) {
            try {
                throw new RuntimeException("Imagero can't read EXIF of image file '" + fromFile + "'", t);
            }
            catch (Throwable throwable) {
                this.closeImageReader((ImageReader)imageReader);
                throw throwable;
            }
        }
        return toExifTags.getTagCount() - oldTagCount;
    }

    private void addAllExifTags(JpegReader jpegReader, ExifTags exifTags) {
        IFDEntry[][] allIfdEntries = MetadataUtils.getExif((JpegReader)jpegReader);
        if (allIfdEntries != null) {
            IFDEntry[][] arr$ = allIfdEntries;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                IFDEntry[] currentIfdEntry;
                for (IFDEntry entry : currentIfdEntry = arr$[i$]) {
                    ExifTag exifTag = new ExifTag(entry, ExifIfd.EXIF);
                    ExifTag.Properties exifTagId = exifTag.parseProperties();
                    if (exifTagId.isGpsTag()) {
                        exifTags.addGpsTag(new ExifTag(entry, ExifIfd.GPS));
                        continue;
                    }
                    if (exifTagId.isMakerNoteTag()) {
                        exifTags.addMakerNoteTag(new ExifTag(entry, ExifIfd.MAKER_NOTE));
                        continue;
                    }
                    exifTags.addExifTag(exifTag);
                }
            }
        }
    }

    private void closeImageReader(ImageReader imageReader) {
        if (imageReader != null) {
            imageReader.close();
        }
    }

    private void addTagsOfIfd(ImageFileDirectory ifd, ExifIfd ifdType, ExifTags exifTags) {
        ImageFileDirectory interoperabilityIFD;
        ImageFileDirectory gpsIFD;
        if (!ifdType.equals((Object)ExifIfd.UNDEFINED)) {
            this.addExifTags(ifd, ifdType, exifTags);
        }
        for (int i = 0; i < ifd.getIFDCount(); ++i) {
            ImageFileDirectory subIfd = ifd.getIFDAt(i);
            this.addTagsOfIfd(subIfd, ExifIfd.UNDEFINED, exifTags);
        }
        ImageFileDirectory exifIFD = ifd.getExifIFD();
        if (exifIFD != null) {
            this.addTagsOfIfd(exifIFD, ExifIfd.EXIF, exifTags);
        }
        if ((gpsIFD = ifd.getGpsIFD()) != null) {
            this.addTagsOfIfd(gpsIFD, ExifIfd.GPS, exifTags);
        }
        if ((interoperabilityIFD = ifd.getInteroperabilityIFD()) != null) {
            this.addTagsOfIfd(interoperabilityIFD, ExifIfd.INTEROPERABILITY, exifTags);
        }
    }

    private void addExifTags(ImageFileDirectory ifd, ExifIfd ifdType, ExifTags exifTags) {
        int entryCount = ifd.getEntryCount();
        block6: for (int i = 0; i < entryCount; ++i) {
            IFDEntry ifdEntry = ifd.getEntryAt(i);
            if (ifdEntry == null) continue;
            ExifTag exifTag = new ExifTag(ifdEntry, ifdType);
            switch (ifdType) {
                case EXIF: {
                    exifTags.addExifTag(exifTag);
                    continue block6;
                }
                case GPS: {
                    exifTags.addGpsTag(exifTag);
                    continue block6;
                }
                case INTEROPERABILITY: {
                    exifTags.addInteroperabilityTag(exifTag);
                    continue block6;
                }
                case MAKER_NOTE: {
                    exifTags.addMakerNoteTag(exifTag);
                    continue block6;
                }
                default: {
                    assert (false);
                    continue block6;
                }
            }
        }
    }

    static {
        SUPPORTED_FILENAME_SUFFIXES_LOWERCASE.add("arw");
        SUPPORTED_FILENAME_SUFFIXES_LOWERCASE.add("crw");
        SUPPORTED_FILENAME_SUFFIXES_LOWERCASE.add("cr2");
        SUPPORTED_FILENAME_SUFFIXES_LOWERCASE.add("dcr");
        SUPPORTED_FILENAME_SUFFIXES_LOWERCASE.add("dng");
        SUPPORTED_FILENAME_SUFFIXES_LOWERCASE.add("jpg");
        SUPPORTED_FILENAME_SUFFIXES_LOWERCASE.add("jpeg");
        SUPPORTED_FILENAME_SUFFIXES_LOWERCASE.add("mrw");
        SUPPORTED_FILENAME_SUFFIXES_LOWERCASE.add("nef");
        SUPPORTED_FILENAME_SUFFIXES_LOWERCASE.add("thm");
        SUPPORTED_FILENAME_SUFFIXES_LOWERCASE.add("tif");
        SUPPORTED_FILENAME_SUFFIXES_LOWERCASE.add("tiff");
        SUPPORTED_FILENAME_SUFFIXES_LOWERCASE.add("srw");
    }
}

