/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif;

import java.util.ArrayList;
import java.util.List;
import org.jphototagger.exif.ExifIfd;
import org.jphototagger.exif.ExifTag;

public final class ExifToSaveInRepository {
    private static final List<ExifTag.Properties> EXIF_TAG_IDS_TO_SAVE = new ArrayList<ExifTag.Properties>();

    public static boolean isSaveInRepository(ExifTag.Properties exifTagId) {
        if (exifTagId == null) {
            throw new NullPointerException("exifTagId == null");
        }
        return EXIF_TAG_IDS_TO_SAVE.contains((Object)exifTagId);
    }

    public static boolean isSaveInRepository(ExifIfd ifdType, ExifTag.Properties id) {
        if (ifdType == null) {
            throw new NullPointerException("ifdType == null");
        }
        if (id == null) {
            throw new NullPointerException("id == null");
        }
        switch (ifdType) {
            case EXIF: {
                return EXIF_TAG_IDS_TO_SAVE.contains((Object)id);
            }
        }
        return false;
    }

    private ExifToSaveInRepository() {
    }

    static {
        EXIF_TAG_IDS_TO_SAVE.add(ExifTag.Properties.DATE_TIME_ORIGINAL);
        EXIF_TAG_IDS_TO_SAVE.add(ExifTag.Properties.FOCAL_LENGTH);
        EXIF_TAG_IDS_TO_SAVE.add(ExifTag.Properties.ISO_SPEED_RATINGS);
        EXIF_TAG_IDS_TO_SAVE.add(ExifTag.Properties.MODEL);
        EXIF_TAG_IDS_TO_SAVE.add(ExifTag.Properties.MAKER_NOTE_LENS);
    }
}

