/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif;

import java.util.HashMap;
import java.util.Map;
import org.jphototagger.exif.ExifTag;

public final class ExifThumbnailUtil {
    private static final Map<String, Double> ROTATION_ANGLE_OF_STRING = new HashMap<String, Double>();

    public static double getThumbnailRotationAngle(ExifTag exifTag) {
        assert (exifTag == null || exifTag.getTagId() == 274);
        if (exifTag != null) {
            Double angle = ROTATION_ANGLE_OF_STRING.get(exifTag.getStringValue());
            if (angle == null) {
                return 0.0;
            }
            return angle;
        }
        return 0.0;
    }

    private ExifThumbnailUtil() {
    }

    static {
        ROTATION_ANGLE_OF_STRING.put("(0, 0) is top-left", new Double(0.0));
        ROTATION_ANGLE_OF_STRING.put("(0, 0) is top-right", new Double(0.0));
        ROTATION_ANGLE_OF_STRING.put("0, 0) is bottom-right", new Double(180.0));
        ROTATION_ANGLE_OF_STRING.put("(0, 0) is bottom-left", new Double(180.0));
        ROTATION_ANGLE_OF_STRING.put("(0, 0) is left-top", new Double(90.0));
        ROTATION_ANGLE_OF_STRING.put("(0, 0) is right-top", new Double(90.0));
        ROTATION_ANGLE_OF_STRING.put("(0, 0) is right-bottom", new Double(270.0));
        ROTATION_ANGLE_OF_STRING.put("(0, 0) is left-bottom", new Double(270.0));
    }
}

