/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.jphototagger.exif.ExifTag;
import org.jphototagger.lib.xml.bind.XmlObjectExporter;
import org.jphototagger.lib.xml.bind.XmlObjectImporter;

@XmlRootElement(name="exiftags")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={ExifTag.class})
public final class ExifTags {
    private long lastModified = -1L;
    private String makerNoteDescription;
    private final Set<ExifTag> exifTags = new HashSet<ExifTag>();
    private final Set<ExifTag> gpsTags = new HashSet<ExifTag>();
    private final Set<ExifTag> interoperabilityTags = new HashSet<ExifTag>();
    private final Set<ExifTag> makerNoteTags = new HashSet<ExifTag>();

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public Set<ExifTag> getExifTags() {
        return Collections.unmodifiableSet(this.exifTags);
    }

    public Set<ExifTag> getGpsTags() {
        return Collections.unmodifiableSet(this.gpsTags);
    }

    public Set<ExifTag> getInteroperabilityTags() {
        return Collections.unmodifiableSet(this.interoperabilityTags);
    }

    public Set<ExifTag> getMakerNoteTags() {
        return Collections.unmodifiableSet(this.makerNoteTags);
    }

    public int getTagCount() {
        return this.exifTags.size() + this.gpsTags.size() + this.interoperabilityTags.size() + this.makerNoteTags.size();
    }

    public List<ExifTag> getAllTagsAsList() {
        ArrayList<ExifTag> allTags = new ArrayList<ExifTag>(this.getTagCount());
        allTags.addAll(this.exifTags);
        allTags.addAll(this.gpsTags);
        allTags.addAll(this.interoperabilityTags);
        allTags.addAll(this.makerNoteTags);
        return allTags;
    }

    public void addExifTag(ExifTag exifTag) {
        if (exifTag == null) {
            throw new NullPointerException("exifTag == null");
        }
        this.exifTags.add(exifTag);
    }

    public void addGpsTag(ExifTag exifTag) {
        if (exifTag == null) {
            throw new NullPointerException("exifTag == null");
        }
        this.gpsTags.add(exifTag);
    }

    public void addInteroperabilityTag(ExifTag exifTag) {
        if (exifTag == null) {
            throw new NullPointerException("exifTag == null");
        }
        this.interoperabilityTags.add(exifTag);
    }

    public void addMakerNoteTags(Collection<ExifTag> tags) {
        if (tags == null) {
            throw new NullPointerException("tags == null");
        }
        this.makerNoteTags.addAll(tags);
    }

    public void addMakerNoteTag(ExifTag exifTag) {
        if (exifTag == null) {
            throw new NullPointerException("exifTag == null");
        }
        this.makerNoteTags.add(exifTag);
    }

    public String getMakerNoteDescription() {
        return this.makerNoteDescription;
    }

    public void setMakerNoteDescription(String makerNoteDescription) {
        if (makerNoteDescription == null) {
            throw new NullPointerException("makerNoteDescription == null");
        }
        this.makerNoteDescription = makerNoteDescription;
    }

    public ExifTag findExifTagByTagId(int tagId) {
        return this.findExifTagByTagId(this.exifTags, tagId);
    }

    public ExifTag findGpsTagByTagId(int tagId) {
        return this.findExifTagByTagId(this.gpsTags, tagId);
    }

    public ExifTag findInteroparabilityTagByTagId(int tagId) {
        return this.findExifTagByTagId(this.interoperabilityTags, tagId);
    }

    public ExifTag findmakerNoteTagByTagId(int tagId) {
        return this.findExifTagByTagId(this.makerNoteTags, tagId);
    }

    public void removeFromExifTags(ExifTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag == null");
        }
        this.exifTags.remove(tag);
    }

    public void removeFromMakerNoteTags(ExifTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag == null");
        }
        this.makerNoteTags.remove(tag);
    }

    public void removeFromInteroperabilityTags(ExifTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag == null");
        }
        this.interoperabilityTags.remove(tag);
    }

    public void removeFromGpsTags(ExifTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag == null");
        }
        this.gpsTags.remove(tag);
    }

    private ExifTag findExifTagByTagId(Collection<ExifTag> tags, int id) {
        for (ExifTag tag : tags) {
            if (tag.getTagId() != id) continue;
            return tag;
        }
        return null;
    }

    public void writeToFile(File file) throws Exception {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        XmlObjectExporter.export((Object)this, (File)file);
    }

    public static ExifTags readFromFile(File file) throws Exception {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        return (ExifTags)XmlObjectImporter.importObject((File)file, ExifTags.class);
    }
}

