/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif;

import com.imagero.reader.tiff.IFDEntry;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jphototagger.exif.ExifIfd;
import org.jphototagger.exif.datatype.ExifValueType;
import org.jphototagger.lib.xml.bind.Base64ByteArrayXmlAdapter;
import org.jphototagger.lib.xml.bind.Base64ByteStringXmlAdapter;

@XmlRootElement(name="exiftag")
@XmlAccessorType(value=XmlAccessType.FIELD)
public final class ExifTag {
    private static final int ANY_VALUE_COUNT = -1;
    private final ExifIfd ifd;
    private final int tagId;
    private final int intValueType;
    private final int valueCount;
    private final long valueOffset;
    @XmlJavaTypeAdapter(value=Base64ByteArrayXmlAdapter.class)
    private byte[] rawValue;
    @XmlJavaTypeAdapter(value=Base64ByteStringXmlAdapter.class)
    private final String stringValue;
    private final String name;
    private final int intByteOrder;

    public ExifTag() {
        this.valueOffset = -1L;
        this.rawValue = new byte[0];
        this.stringValue = "";
        this.name = "";
        this.intByteOrder = -1;
        this.valueCount = -1;
        this.tagId = -1;
        this.intValueType = -1;
        this.ifd = ExifIfd.UNDEFINED;
    }

    public ExifTag(IFDEntry entry, ExifIfd ifd) {
        if (entry == null) {
            throw new NullPointerException("ifd == null");
        }
        if (ifd == null) {
            throw new NullPointerException("ifdType == null");
        }
        this.tagId = entry.getTag();
        this.valueCount = entry.getCount();
        this.valueOffset = entry.getValueOffset();
        this.intValueType = entry.getType();
        this.name = entry.getEntryMeta().getName();
        this.intByteOrder = entry.parent.getByteOrder();
        this.rawValue = this.deepCopyRawValueOfIfdEntry(entry);
        this.stringValue = entry.toString();
        this.ifd = ifd;
    }

    public ExifTag(int tagId, int intValueType, int valueCount, long valueOffset, byte[] rawValue, String stringValue, int intByteOrder, String name, ExifIfd ifd) {
        this.tagId = tagId;
        this.intValueType = intValueType;
        this.valueCount = valueCount;
        this.valueOffset = valueOffset;
        this.rawValue = rawValue == null ? new byte[]{} : Arrays.copyOf(rawValue, rawValue.length);
        this.stringValue = stringValue;
        this.intByteOrder = intByteOrder;
        this.name = name;
        this.ifd = ifd;
    }

    public ByteOrder convertByteOrderIdToByteOrder() {
        return this.intByteOrder == 18761 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    public int getByteOrderId() {
        return this.intByteOrder;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getRawValue() {
        return Arrays.copyOf(this.rawValue, this.rawValue.length);
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public int getTagId() {
        return this.tagId;
    }

    public ExifIfd getIfd() {
        return this.ifd;
    }

    public long getValueOffset() {
        return this.valueOffset;
    }

    public int getValueCount() {
        return this.valueCount;
    }

    public int getIntValueType() {
        return this.intValueType;
    }

    public ExifValueType parseValueType() {
        return ExifValueType.parseInt(this.intValueType);
    }

    public Properties parseProperties() {
        return Properties.parseInt(this.tagId);
    }

    private byte[] deepCopyRawValueOfIfdEntry(IFDEntry entry) {
        try {
            return Arrays.copyOf(entry.getRawValue(), entry.getRawValue().length);
        }
        catch (Throwable t) {
            Logger.getLogger(ExifTag.class.getName()).log(Level.SEVERE, null, t);
            return null;
        }
    }

    public String toString() {
        return this.name == null ? this.parseValueType().name() : this.name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExifTag)) {
            return false;
        }
        ExifTag other = (ExifTag)obj;
        return this.ifd == other.ifd && this.tagId == other.tagId;
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + (this.ifd != null ? this.ifd.hashCode() : 0);
        hash = 13 * hash + this.tagId;
        return hash;
    }

    public static enum Properties {
        UNKNOWN(Integer.MIN_VALUE, ExifValueType.UNDEFINED, 0, ExifIfd.UNDEFINED),
        GPS_VERSION_ID(0, ExifValueType.BYTE, 4, ExifIfd.GPS),
        GPS_LATITUDE_REF(1, ExifValueType.ASCII, 2, ExifIfd.GPS),
        GPS_LATITUDE(2, ExifValueType.RATIONAL, 3, ExifIfd.GPS),
        GPS_LONGITUDE_REF(3, ExifValueType.ASCII, 2, ExifIfd.GPS),
        GPS_LONGITUDE(4, ExifValueType.RATIONAL, 3, ExifIfd.GPS),
        GPS_ALTITUDE_REF(5, ExifValueType.BYTE, 1, ExifIfd.GPS),
        GPS_ALTITUDE(6, ExifValueType.RATIONAL, 1, ExifIfd.GPS),
        GPS_TIME_STAMP(7, ExifValueType.RATIONAL, 3, ExifIfd.GPS),
        GPS_SATELLITES(8, ExifValueType.ASCII, -1, ExifIfd.GPS),
        GPS_DATE_STAMP(29, ExifValueType.ASCII, 11, ExifIfd.GPS),
        IMAGE_WIDTH(256, ExifValueType.SHORT_OR_LONG, 1, ExifIfd.EXIF),
        IMAGE_LENGTH(257, ExifValueType.SHORT_OR_LONG, 1, ExifIfd.EXIF),
        BITS_PER_SAMPLE(258, ExifValueType.SHORT, 3, ExifIfd.EXIF),
        IMAGE_DESCRIPTION(270, ExifValueType.ASCII, -1, ExifIfd.EXIF),
        MAKE(271, ExifValueType.ASCII, -1, ExifIfd.EXIF),
        MODEL(272, ExifValueType.ASCII, -1, ExifIfd.EXIF),
        SOFTWARE(305, ExifValueType.ASCII, -1, ExifIfd.EXIF),
        DATE_TIME(306, ExifValueType.ASCII, 20, ExifIfd.EXIF),
        ARTIST(315, ExifValueType.ASCII, -1, ExifIfd.EXIF),
        COPYRIGHT(33432, ExifValueType.ASCII, -1, ExifIfd.EXIF),
        EXPOSURE_TIME(33434, ExifValueType.RATIONAL, 1, ExifIfd.EXIF),
        F_NUMBER(33437, ExifValueType.RATIONAL, 1, ExifIfd.EXIF),
        EXPOSURE_PROGRAM(34850, ExifValueType.SHORT, 1, ExifIfd.EXIF),
        SPECTRAL_SENSITIVITY(34852, ExifValueType.ASCII, -1, ExifIfd.EXIF),
        ISO_SPEED_RATINGS(34855, ExifValueType.SHORT, -1, ExifIfd.EXIF),
        DATE_TIME_ORIGINAL(36867, ExifValueType.ASCII, 20, ExifIfd.EXIF),
        DATE_TIME_DIGITIZED(36868, ExifValueType.ASCII, 20, ExifIfd.EXIF),
        MAKER_NOTE(37500, ExifValueType.UNDEFINED, -1, ExifIfd.MAKER_NOTE),
        METERING_MODE(37383, ExifValueType.SHORT, 1, ExifIfd.EXIF),
        FLASH(37385, ExifValueType.SHORT, 1, ExifIfd.EXIF),
        FOCAL_LENGTH(37386, ExifValueType.RATIONAL, 1, ExifIfd.EXIF),
        USER_COMMENT(37510, ExifValueType.UNDEFINED, -1, ExifIfd.EXIF),
        FILE_SOURCE(41728, ExifValueType.UNDEFINED, 1, ExifIfd.EXIF),
        EXPOSURE_MODE(41986, ExifValueType.SHORT, 1, ExifIfd.EXIF),
        WHITE_BALANCE(41987, ExifValueType.SHORT, 1, ExifIfd.EXIF),
        FOCAL_LENGTH_IN_35_MM_FILM(41989, ExifValueType.SHORT, 1, ExifIfd.EXIF),
        CONTRAST(41992, ExifValueType.SHORT, 1, ExifIfd.EXIF),
        SATURATION(41993, ExifValueType.SHORT, 1, ExifIfd.EXIF),
        SHARPNESS(41994, ExifValueType.SHORT, 1, ExifIfd.EXIF),
        SUBJECT_DISTANCE_RANGE(41996, ExifValueType.SHORT, 1, ExifIfd.EXIF),
        IMAGE_UNIQUE_ID(42016, ExifValueType.ASCII, 33, ExifIfd.EXIF),
        MAKER_NOTE_LENS(3750010, ExifValueType.UNDEFINED, -1, ExifIfd.UNDEFINED),
        MAKER_NOTE_CANON_START(3751000, ExifValueType.UNDEFINED, -1, ExifIfd.UNDEFINED),
        MAKER_NOTE_NIKON_START(3752000, ExifValueType.UNDEFINED, -1, ExifIfd.UNDEFINED);

        private final int tagId;
        private final ExifValueType valueType;
        private final int valueCount;
        private final ExifIfd ifd;
        @XmlTransient
        private static final Set<Properties> GPS_TAGS;

        private Properties(int value, ExifValueType valueType, int valueCount, ExifIfd ifd) {
            this.tagId = value;
            this.valueType = valueType;
            this.valueCount = valueCount;
            this.ifd = ifd;
        }

        public int getTagId() {
            return this.tagId;
        }

        public static Properties parseInt(int anInt) {
            for (Properties id : Properties.values()) {
                if (id.tagId != anInt) continue;
                return id;
            }
            return UNKNOWN;
        }

        public boolean isGpsTag() {
            return GPS_TAGS.contains((Object)this);
        }

        public boolean isMakerNoteTag() {
            return MAKER_NOTE.equals((Object)this);
        }

        public ExifValueType getValueType() {
            return this.valueType;
        }

        public int getValueCount() {
            return this.valueCount;
        }

        public ExifIfd getIfd() {
            return this.ifd;
        }

        public boolean isAnyValueCount() {
            return this.valueCount < 0;
        }

        static {
            GPS_TAGS = EnumSet.of(GPS_ALTITUDE, new Properties[]{GPS_ALTITUDE_REF, GPS_DATE_STAMP, GPS_LATITUDE, GPS_LATITUDE_REF, GPS_LONGITUDE, GPS_LONGITUDE_REF, GPS_SATELLITES, GPS_TIME_STAMP, GPS_VERSION_ID});
        }
    }
}

