/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.domain.metadata.exif.Exif;
import org.jphototagger.exif.ExifMakerNotesAdder;
import org.jphototagger.exif.ExifTag;
import org.jphototagger.exif.ExifTags;
import org.jphototagger.exif.ExifTagsProvider;
import org.jphototagger.exif.cache.ExifCache;
import org.jphototagger.exif.datatype.ExifAscii;
import org.jphototagger.exif.formatter.ExifFormatterAscii;
import org.jphototagger.exif.tag.ExifGpsLatitude;
import org.jphototagger.exif.tag.ExifGpsLongitude;
import org.jphototagger.exif.tag.ExifGpsMetadata;
import org.jphototagger.exif.tag.ExifGpsUtil;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.util.NumberUtil;
import org.openide.util.Lookup;

public final class ExifSupport {
    private static final Logger LOGGER = Logger.getLogger(ExifSupport.class.getName());
    private static final CharsetEncoder ASCII_ENCODER = Charset.forName("US-ASCII").newEncoder();
    public static final ExifSupport INSTANCE = new ExifSupport();
    public static final String PREF_KEY_EXCLUDE_FROM_READ_SUFFIXES = "ExifSettings.ExcludeFromReadSuffixes";
    private static final Set<String> SUPPORTED_FILENAME_SUFFIXES_LOWERCASE = new HashSet<String>();
    private static final Set<String> EXCLUDE_FILENAME_SUFFIXES_LOWERCASE = new CopyOnWriteArraySet<String>();
    private static final Map<String, List<ExifTagsProvider>> EXIF_TAGS_PROVIDERS_OF_FILENAMESUFFIX = new HashMap<String, List<ExifTagsProvider>>();

    private static void setExcludeFilenameSuffixes(Collection<? extends String> suffixes) {
        EXCLUDE_FILENAME_SUFFIXES_LOWERCASE.clear();
        for (String string : suffixes) {
            EXCLUDE_FILENAME_SUFFIXES_LOWERCASE.add(string.toLowerCase());
        }
    }

    public Set<String> getSupportedSuffixes() {
        return Collections.unmodifiableSet(SUPPORTED_FILENAME_SUFFIXES_LOWERCASE);
    }

    public boolean canReadExif(File file) {
        String suffix = FileUtil.getSuffix((File)file);
        String suffixLowerCase = suffix.toLowerCase();
        return !EXCLUDE_FILENAME_SUFFIXES_LOWERCASE.contains(suffixLowerCase) && SUPPORTED_FILENAME_SUFFIXES_LOWERCASE.contains(suffixLowerCase);
    }

    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void preferencesChanged(PreferencesChangedEvent evt) {
        if (PREF_KEY_EXCLUDE_FROM_READ_SUFFIXES.equals(evt.getKey())) {
            ExifSupport.setExcludeFilenameSuffixes((Collection)evt.getNewValue());
        }
    }

    public Collection<? extends String> getExludeFilenameSuffixes() {
        return Collections.unmodifiableCollection(EXCLUDE_FILENAME_SUFFIXES_LOWERCASE);
    }

    Exif getExifPreferCached(File imageFile) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        return this.createExifFromTags(this.getExifTagsPreferCached(imageFile));
    }

    public ExifTags getExifTagsPreferCached(File imageFile) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        if (ExifCache.INSTANCE.containsUpToDateExifTags(imageFile)) {
            return ExifCache.INSTANCE.getCachedExifTags(imageFile);
        }
        ExifTags exifTags = null;
        if (this.canReadExif(imageFile)) {
            exifTags = this.getExifTags(imageFile);
        }
        if (exifTags == null) {
            ExifCache.INSTANCE.cacheExifTags(imageFile, new ExifTags());
        } else {
            ExifCache.INSTANCE.cacheExifTags(imageFile, exifTags);
        }
        return exifTags;
    }

    Exif getExif(File imageFile) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        ExifTags exifTags = this.getExifTags(imageFile);
        return this.createExifFromTags(exifTags);
    }

    ExifTags getExifTags(File file) {
        if (file == null || !file.exists() || !this.canReadExif(file)) {
            return null;
        }
        ExifTags exifTags = new ExifTags();
        try {
            String suffix = FileUtil.getSuffix((File)file).toLowerCase();
            for (ExifTagsProvider provider : EXIF_TAGS_PROVIDERS_OF_FILENAMESUFFIX.get(suffix)) {
                try {
                    LOGGER.log(Level.INFO, "Reading EXIF from image file ''{0}'', size {1} Bytes. Using {2}.", new Object[]{file, file.length(), provider.getClass()});
                    int countAdded = provider.addToExifTags(file, exifTags);
                    if (countAdded <= 0) continue;
                    return exifTags;
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, null, t);
                }
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
        }
        ExifMakerNotesAdder.addMakerNotesToExifTags(file, exifTags);
        return exifTags;
    }

    long getTimeTakenInMillis(File file) {
        ExifTags exifTags = this.getExifTags(file);
        if (exifTags == null) {
            return file.lastModified();
        }
        ExifTag dateTimeTag = exifTags.findExifTagByTagId(ExifTag.Properties.DATE_TIME_ORIGINAL.getTagId());
        if (dateTimeTag == null) {
            dateTimeTag = exifTags.findExifTagByTagId(ExifTag.Properties.DATE_TIME_DIGITIZED.getTagId());
        }
        if (dateTimeTag == null) {
            dateTimeTag = exifTags.findExifTagByTagId(ExifTag.Properties.DATE_TIME.getTagId());
        }
        if (dateTimeTag == null) {
            return file.lastModified();
        }
        String dateTimeString = dateTimeTag.getStringValue().trim();
        int dateTimeStringLength = dateTimeString.length();
        if (dateTimeStringLength < 19) {
            return file.lastModified();
        }
        long timestamp = this.exifDateTimeStringToTimestamp(dateTimeString);
        return timestamp < 0L ? file.lastModified() : timestamp;
    }

    long exifDateTimeStringToTimestamp(String dateTimeString) {
        if (dateTimeString.length() < 19) {
            return -1L;
        }
        try {
            String yearString = dateTimeString.substring(0, 4);
            String monthString = dateTimeString.substring(5, 7);
            String dayString = dateTimeString.substring(8, 10);
            String hoursString = dateTimeString.substring(11, 13);
            String minutesString = dateTimeString.substring(14, 16);
            String secondsString = dateTimeString.substring(17, 19);
            if (!NumberUtil.allStringsAreIntegers(Arrays.asList(yearString, monthString, dayString, hoursString, minutesString, secondsString))) {
                return -1L;
            }
            int year = Integer.parseInt(yearString);
            int month = Integer.parseInt(monthString);
            int day = Integer.parseInt(dayString);
            int hours = Integer.parseInt(hoursString);
            int minutes = Integer.parseInt(minutesString);
            int seconds = Integer.parseInt(secondsString);
            GregorianCalendar calendar = new GregorianCalendar();
            if (year < 1839) {
                LOGGER.log(Level.WARNING, "Year {0} is not plausible and EXIF date time taken will not be set!", year);
                return -1L;
            }
            calendar.set(year, month - 1, day, hours, minutes, seconds);
            return calendar.getTimeInMillis();
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
            return -1L;
        }
    }

    Exif createExifFromTags(ExifTags exifTags) {
        if (exifTags == null) {
            return null;
        }
        try {
            String recEquipment;
            Exif exif = new Exif();
            ExifTag dateTimeOriginalTag = this.findDateTimeTag(exifTags);
            ExifTag focalLengthTag = exifTags.findExifTagByTagId(ExifTag.Properties.FOCAL_LENGTH.getTagId());
            ExifTag isoSpeedRatingsTag = exifTags.findExifTagByTagId(ExifTag.Properties.ISO_SPEED_RATINGS.getTagId());
            ExifTag modelTag = exifTags.findExifTagByTagId(ExifTag.Properties.MODEL.getTagId());
            ExifTag lensTag = exifTags.findExifTagByTagId(ExifTag.Properties.MAKER_NOTE_LENS.getTagId());
            if (dateTimeOriginalTag != null) {
                this.setExifDateTimeOriginal(exif, dateTimeOriginalTag);
            }
            if (focalLengthTag != null) {
                this.setExifFocalLength(exif, focalLengthTag);
            }
            if (isoSpeedRatingsTag != null) {
                this.setExifIsoSpeedRatings(exif, isoSpeedRatingsTag);
            }
            if (modelTag != null) {
                this.setExifEquipment(exif, modelTag);
            }
            if (lensTag != null && !(recEquipment = lensTag.getStringValue()).isEmpty()) {
                exif.setLens(recEquipment);
            }
            this.setExifGps(exifTags, exif);
            return exif;
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
            return null;
        }
    }

    private ExifTag findDateTimeTag(ExifTags exifTags) {
        ExifTag dateTimeTag = exifTags.findExifTagByTagId(ExifTag.Properties.DATE_TIME_ORIGINAL.getTagId());
        if (dateTimeTag == null) {
            dateTimeTag = exifTags.findExifTagByTagId(ExifTag.Properties.DATE_TIME_DIGITIZED.getTagId());
        }
        if (dateTimeTag == null) {
            dateTimeTag = exifTags.findExifTagByTagId(ExifTag.Properties.DATE_TIME.getTagId());
        }
        return dateTimeTag;
    }

    private void setExifDateTimeOriginal(Exif exif, ExifTag dateTimeOriginalTag) {
        byte[] rawValue = dateTimeOriginalTag.getRawValue();
        if (rawValue == null || rawValue.length < ExifTag.Properties.DATE_TIME_ORIGINAL.getValueCount()) {
            return;
        }
        String dateTimeString = ExifAscii.convertRawValueToString(rawValue).trim();
        if (dateTimeString.length() == 19) {
            long timeInMillis = this.exifDateTimeStringToTimestamp(dateTimeString);
            Date dateTimeOriginal = new Date(timeInMillis < 0L ? 0L : timeInMillis);
            exif.setDateTimeOriginal(dateTimeOriginal);
            exif.setDateTimeOriginalTimestamp(timeInMillis);
        }
    }

    private void setExifEquipment(Exif exif, ExifTag modelTag) {
        ExifFormatterAscii formatter = ExifFormatterAscii.INSTANCE;
        String formattedModelTag = formatter.format(modelTag);
        if (ASCII_ENCODER.canEncode(formattedModelTag = formattedModelTag.trim())) {
            exif.setRecordingEquipment(formattedModelTag);
        }
    }

    private void setExifFocalLength(Exif exif, ExifTag focalLengthTag) {
        try {
            StringTokenizer tokenizer;
            String exifTagStringValue = focalLengthTag.getStringValue();
            StringTokenizer stringTokenizer = tokenizer = exifTagStringValue == null ? new StringTokenizer("") : new StringTokenizer(exifTagStringValue.trim(), "/:");
            if (tokenizer.countTokens() >= 1) {
                double numerator;
                double denominator;
                String denominatorString = tokenizer.nextToken();
                String numeratorString = null;
                if (tokenizer.hasMoreTokens()) {
                    numeratorString = tokenizer.nextToken();
                }
                if (!NumberUtil.isDouble((String)denominatorString)) {
                    return;
                }
                double focalLength = denominator = Double.parseDouble(denominatorString);
                if (NumberUtil.isDouble((String)numeratorString) && (numerator = Double.parseDouble(numeratorString)) != 0.0) {
                    focalLength = denominator / numerator;
                }
                if (focalLength > 0.0) {
                    exif.setFocalLength(focalLength);
                }
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
        }
    }

    private void setExifIsoSpeedRatings(Exif exif, ExifTag isoSpeedRatingsTag) {
        try {
            short isoSpeedRatings;
            String isoSpeedRatingsString;
            String exifTagStringValue = isoSpeedRatingsTag.getStringValue();
            String string = isoSpeedRatingsString = exifTagStringValue == null ? null : exifTagStringValue.trim();
            if (NumberUtil.isShort((String)isoSpeedRatingsString) && (isoSpeedRatings = Short.parseShort(isoSpeedRatingsString)) > 0) {
                exif.setIsoSpeedRatings(isoSpeedRatings);
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
        }
    }

    private void setExifGps(ExifTags fromExifTags, Exif toExif) {
        ExifGpsMetadata gpsMetadata = ExifGpsUtil.createGpsMetadataFromExifTags(fromExifTags);
        ExifGpsLongitude longitude = gpsMetadata.getLongitude();
        ExifGpsLatitude latitude = gpsMetadata.getLatitude();
        if (latitude != null && longitude != null) {
            double longitudeDegrees = ExifGpsUtil.convertExifDegreesToDouble(longitude.getExifDegrees());
            double latitudeDegrees = ExifGpsUtil.convertExifDegreesToDouble(latitude.getExifDegrees());
            if (ExifGpsLatitude.Ref.SOUTH.equals((Object)latitude.getRef())) {
                latitudeDegrees *= -1.0;
            }
            if (ExifGpsLongitude.Ref.WEST.equals((Object)longitude.getRef())) {
                longitudeDegrees *= -1.0;
            }
            toExif.setGpsLatitude(latitudeDegrees);
            toExif.setGpsLongitude(longitudeDegrees);
        }
    }

    private ExifSupport() {
    }

    static {
        for (ExifTagsProvider provider : Lookup.getDefault().lookupAll(ExifTagsProvider.class)) {
            Set<String> suffixes = provider.getSupportedFilenameSuffixes();
            SUPPORTED_FILENAME_SUFFIXES_LOWERCASE.addAll(suffixes);
            for (String suffix : suffixes) {
                String suffixLowerCase = suffix.toLowerCase();
                List<ExifTagsProvider> providers = EXIF_TAGS_PROVIDERS_OF_FILENAMESUFFIX.get(suffixLowerCase);
                if (providers == null) {
                    providers = new ArrayList<ExifTagsProvider>();
                    EXIF_TAGS_PROVIDERS_OF_FILENAMESUFFIX.put(suffixLowerCase, providers);
                }
                providers.add(provider);
            }
        }
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        ExifSupport.setExcludeFilenameSuffixes(prefs.getStringCollection(PREF_KEY_EXCLUDE_FROM_READ_SUFFIXES));
        AnnotationProcessor.process((Object)INSTANCE);
    }
}

